import type { GraphQLArgument, GraphQLField, GraphQLInputField, GraphQLNamedType } from 'graphql';
import { ReactNode } from 'react';
export declare type ExplorerFieldDef = GraphQLField<{}, {}, {}> | GraphQLInputField | GraphQLArgument;
export declare type ExplorerNavStackItem = {
    name: string;
    title?: string;
    search?: string;
    def?: GraphQLNamedType | ExplorerFieldDef;
};
export declare type ExplorerNavStack = [
    ExplorerNavStackItem,
    ...ExplorerNavStackItem[]
];
export declare type ExplorerContextType = {
    explorerNavStack: ExplorerNavStack;
    hide(): void;
    isVisible: boolean;
    push(item: ExplorerNavStackItem): void;
    pop(): void;
    reset(): void;
    show(): void;
    showSearch(search: string): void;
};
export declare const ExplorerContext: import("react").Context<ExplorerContextType | null>;
declare type ExplorerContextProviderProps = {
    children: ReactNode;
    isVisible?: boolean;
    onToggleVisibility?(isVisible: boolean): void;
};
export declare function ExplorerContextProvider(props: ExplorerContextProviderProps): JSX.Element;
export declare const useExplorerContext: {
    (options: {
        nonNull: true;
        caller?: Function | undefined;
    }): ExplorerContextType;
    (options: {
        nonNull?: boolean | undefined;
        caller?: Function | undefined;
    }): ExplorerContextType | null;
    (): ExplorerContextType | null;
};
export {};
