"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ava_1 = require("ava");
var _1 = require(".");
ava_1.default('parseImportLine: parse single import', function (t) {
    t.deepEqual(_1.parseImportLine("import A from \"schema.graphql\""), {
        imports: ['A'],
        from: 'schema.graphql',
    });
});
ava_1.default('parseImportLine: parse multi import', function (t) {
    t.deepEqual(_1.parseImportLine("import A, B from \"schema.graphql\""), {
        imports: ['A', 'B'],
        from: 'schema.graphql',
    });
});
ava_1.default('parseImportLine: parse multi import (weird spacing)', function (t) {
    t.deepEqual(_1.parseImportLine("import  A  ,B   from \"schema.graphql\""), {
        imports: ['A', 'B'],
        from: 'schema.graphql',
    });
});
ava_1.default('parseImportLine: different path', function (t) {
    t.deepEqual(_1.parseImportLine("import A from \"../new/schema.graphql\""), {
        imports: ['A'],
        from: '../new/schema.graphql',
    });
});
ava_1.default('parse: multi line import', function (t) {
    var sdl = "# import A from \"a.graphql\"\n# import * from \"b.graphql\"\n  ";
    t.deepEqual(_1.parseSDL(sdl), [
        {
            imports: ['A'],
            from: 'a.graphql',
        },
        {
            imports: ['*'],
            from: 'b.graphql',
        },
    ]);
});
ava_1.default('importSchema: field types', function (t) {
    var expectedSDL = "type A {\n  first: String @first\n  second: Float\n  b: B\n}\n\ntype B {\n  c: C\n  hello: String!\n}\n\ntype C {\n  id: ID!\n}\n";
    t.is(_1.importSchema('fixtures/field-types/a.graphql'), expectedSDL);
});
ava_1.default('importSchema: enums', function (t) {
    var expectedSDL = "type A {\n  first: String @first\n  second: Float\n  b: B\n}\n\nenum B {\n  B1\n  B2\n  B3\n}\n";
    t.is(_1.importSchema('fixtures/enums/a.graphql'), expectedSDL);
});
ava_1.default('importSchema: import all', function (t) {
    var expectedSDL = "type A {\n  first: String @first\n  second: Float\n  b: B\n}\n\ntype B {\n  hello: String!\n  c1: C1\n  c2: C2\n}\n\ntype C1 {\n  id: ID!\n}\n\ntype C2 {\n  id: ID!\n}\n";
    t.is(_1.importSchema('fixtures/import-all/a.graphql'), expectedSDL);
});
ava_1.default('importSchema: unions', function (t) {
    var expectedSDL = "type A {\n  b: B\n}\n\nunion B = C1 | C2\n\ntype C1 {\n  c1: ID\n}\n\ntype C2 {\n  c2: ID\n}\n";
    t.is(_1.importSchema('fixtures/unions/a.graphql'), expectedSDL);
});
ava_1.default('importSchema: scalar', function (t) {
    var expectedSDL = "type A {\n  b: B\n}\n\nscalar B\n";
    t.is(_1.importSchema('fixtures/scalar/a.graphql'), expectedSDL);
});
ava_1.default('importSchema: interfaces', function (t) {
    var expectedSDL = "type A implements B {\n  first: String @first\n  second: Float\n}\n\ninterface B {\n  second: Float\n  c: [C!]!\n}\n\ntype C {\n  c: ID!\n}\n";
    t.is(_1.importSchema('fixtures/interfaces/a.graphql'), expectedSDL);
});
ava_1.default('importSchema: interfaces-implements', function (t) {
    var expectedSDL = "type A implements B {\n  id: ID!\n}\n\ninterface B {\n  id: ID!\n}\n\ntype B1 implements B {\n  id: ID!\n}\n";
    t.is(_1.importSchema('fixtures/interfaces-implements/a.graphql'), expectedSDL);
});
ava_1.default('importSchema: input types', function (t) {
    var expectedSDL = "type A {\n  first(b: B): String @first\n  second: Float\n}\n\ninput B {\n  hello: [C!]!\n}\n\ninput C {\n  id: ID!\n}\n";
    t.is(_1.importSchema('fixtures/input-types/a.graphql'), expectedSDL);
});
ava_1.default('importSchema: complex test', function (t) {
    t.notThrows(function () {
        _1.importSchema('fixtures/complex/a.graphql');
    });
});
ava_1.default('circular imports', function (t) {
    var expectedSDL = "type A {\n  first: String @first\n  second: Float\n  b: B\n}\n\ntype B {\n  hello: String!\n  c1: C1\n  c2: C2\n  a: A\n}\n\ntype C1 {\n  id: ID!\n}\n\ntype C2 {\n  id: ID!\n}\n";
    var actualSDL = _1.importSchema('fixtures/circular/a.graphql');
    t.is(actualSDL, expectedSDL);
});
ava_1.default('related types', function (t) {
    var expectedSDL = "type A {\n  first: String @first\n  second: Float\n  b: B\n}\n\ntype B {\n  hello: String!\n  c1: C\n}\n\ntype C {\n  field: String\n}\n";
    var actualSDL = _1.importSchema('fixtures/related-types/a.graphql');
    t.is(actualSDL, expectedSDL);
});
ava_1.default('relative paths', function (t) {
    var expectedSDL = "type Query {\n  feed: [Post!]!\n}\n\ntype Mutation {\n  createDraft(title: String!, text: String): Post\n  publish(id: ID!): Post\n}\n\ntype Post implements Node {\n  id: ID!\n  isPublished: Boolean!\n  title: String!\n  text: String!\n}\n\ninterface Node {\n  id: ID!\n}\n";
    var actualSDL = _1.importSchema('fixtures/relative-paths/src/schema.graphql');
    t.is(actualSDL, expectedSDL);
});
//# sourceMappingURL=index.test.js.map