'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const core = require('@graphql-toolkit/core');
const urlLoader = require('@graphql-toolkit/url-loader');
const jsonFileLoader = require('@graphql-toolkit/json-file-loader');
const graphqlFileLoader = require('@graphql-toolkit/graphql-file-loader');
const codeFileLoader = require('@graphql-toolkit/code-file-loader');
const gitLoader = require('@graphql-toolkit/git-loader');
const githubLoader = require('@graphql-toolkit/github-loader');
const apolloEngineLoader = require('@graphql-toolkit/apollo-engine-loader');
const prismaLoader = require('@graphql-toolkit/prisma-loader');
const graphql = require('graphql');

const importSchema = (schema, schemas) => core.loadTypedefsUsingLoaders([
    new urlLoader.UrlLoader(),
    new jsonFileLoader.JsonFileLoader(),
    new graphqlFileLoader.GraphQLFileLoader(),
    new codeFileLoader.CodeFileLoader(),
    new gitLoader.GitLoader(),
    new githubLoader.GithubLoader(),
    new apolloEngineLoader.ApolloEngineLoader(),
    new prismaLoader.PrismaLoader()
], schema, { schemas, forceGraphQLImport: true }, core.OPERATION_KINDS).then(r => graphql.print(r[0].document));

exports.importSchema = importSchema;
