import { loadTypedefsUsingLoaders, OPERATION_KINDS } from '@graphql-toolkit/core';
import { UrlLoader } from '@graphql-toolkit/url-loader';
import { JsonFileLoader } from '@graphql-toolkit/json-file-loader';
import { GraphQLFileLoader } from '@graphql-toolkit/graphql-file-loader';
import { CodeFileLoader } from '@graphql-toolkit/code-file-loader';
import { GitLoader } from '@graphql-toolkit/git-loader';
import { GithubLoader } from '@graphql-toolkit/github-loader';
import { ApolloEngineLoader } from '@graphql-toolkit/apollo-engine-loader';
import { PrismaLoader } from '@graphql-toolkit/prisma-loader';
import { print } from 'graphql';

const importSchema = (schema, schemas) => loadTypedefsUsingLoaders([
    new UrlLoader(),
    new JsonFileLoader(),
    new GraphQLFileLoader(),
    new CodeFileLoader(),
    new GitLoader(),
    new GithubLoader(),
    new ApolloEngineLoader(),
    new PrismaLoader()
], schema, { schemas, forceGraphQLImport: true }, OPERATION_KINDS).then(r => print(r[0].document));

export { importSchema };
