'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGraphQLConfig = getGraphQLConfig;

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _GraphQLConfig = require('./GraphQLConfig');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Given a config directory, returns a GraphQLConfig object.
 * Throws errors if GraphQLConfig object isn't available or fails to be built.
 */
/**
 *  Copyright (c) Facebook, Inc.
 *  All rights reserved.
 *
 *  This source code is licensed under the license found in the
 *  LICENSE file in the root directory of this source tree.
 *
 *  
 */

function getGraphQLConfig(configDir) {
  var rawGraphQLConfig;
  return regeneratorRuntime.async(function getGraphQLConfig$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.next = 2;
          return regeneratorRuntime.awrap(new Promise(function (resolve, reject) {
            return _fs2.default.readFile(_path2.default.join(configDir, _GraphQLConfig.GRAPHQL_CONFIG_NAME), 'utf8', function (error, response) {
              if (error) {
                // eslint-disable-next-line no-console
                console.error('${GRAPHQL_CONFIG_NAME} file is not available in the provided ' + ('config directory: ' + configDir + '\nPlease check the config ') + 'directory path and try again.');
                reject();
              }
              resolve(response);
            });
          }));

        case 2:
          rawGraphQLConfig = _context.sent;
          _context.prev = 3;
          return _context.abrupt('return', new _GraphQLConfig.GraphQLConfig(JSON.parse(rawGraphQLConfig), configDir));

        case 7:
          _context.prev = 7;
          _context.t0 = _context['catch'](3);

          // eslint-disable-next-line no-console
          console.error('Parsing JSON in .graphqlrc file has failed.');
          throw new Error(_context.t0);

        case 11:
        case 'end':
          return _context.stop();
      }
    }
  }, null, this, [[3, 7]]);
}