import { FragmentDefinitionNode, GraphQLDirective, GraphQLSchema } from 'graphql';
import { CompletionItem, AllTypeInfo, IPosition } from 'graphql-language-service-types';
import { CharacterStream, ContextToken, State, ContextTokenForCodeMirror } from 'graphql-language-service-parser';
export declare const SuggestionCommand: {
    command: string;
    title: string;
};
export declare type AutocompleteSuggestionOptions = {
    fillLeafsOnComplete?: boolean;
    schema?: GraphQLSchema;
};
export declare function getAutocompleteSuggestions(schema: GraphQLSchema, queryText: string, cursor: IPosition, contextToken?: ContextTokenForCodeMirror, fragmentDefs?: FragmentDefinitionNode[] | string, options?: AutocompleteSuggestionOptions): Array<CompletionItem>;
export declare function getVariableCompletions(queryText: string, schema: GraphQLSchema, token: ContextToken): CompletionItem[];
export declare function getFragmentDefinitions(queryText: string): Array<FragmentDefinitionNode>;
export declare function getTokenAtPosition(queryText: string, cursor: IPosition): ContextToken;
declare type callbackFnType = (stream: CharacterStream, state: State, style: string, index: number) => void | 'BREAK';
export declare function runOnlineParser(queryText: string, callback: callbackFnType): ContextToken;
export declare function canUseDirective(state: State['prevState'], directive: GraphQLDirective): boolean;
export declare function getTypeInfo(schema: GraphQLSchema, tokenState: State): AllTypeInfo;
export {};
//# sourceMappingURL=getAutocompleteSuggestions.d.ts.map