import { DocumentNode, FragmentSpreadNode, NamedTypeNode } from 'graphql';
import { CompletionItem, Diagnostic, Uri, IPosition, Outline, GraphQLCache } from 'graphql-language-service-types';
import { GraphQLConfig, GraphQLProjectConfig } from 'graphql-config';
import { Hover, SymbolInformation } from 'vscode-languageserver-types';
import { HoverConfig } from './getHoverInformation';
import { DefinitionQueryResult } from './getDefinition';
export declare class GraphQLLanguageService {
    _graphQLCache: GraphQLCache;
    _graphQLConfig: GraphQLConfig;
    constructor(cache: GraphQLCache);
    getConfigForURI(uri: Uri): GraphQLProjectConfig;
    getDiagnostics(query: string, uri: Uri, isRelayCompatMode?: boolean): Promise<Array<Diagnostic>>;
    getAutocompleteSuggestions(query: string, position: IPosition, filePath: Uri): Promise<Array<CompletionItem>>;
    getHoverInformation(query: string, position: IPosition, filePath: Uri, options?: HoverConfig): Promise<Hover['contents']>;
    getDefinition(query: string, position: IPosition, filePath: Uri): Promise<DefinitionQueryResult | null>;
    getDocumentSymbols(document: string, filePath: Uri): Promise<SymbolInformation[]>;
    _getDefinitionForNamedType(query: string, ast: DocumentNode, node: NamedTypeNode, filePath: Uri, projectConfig: GraphQLProjectConfig): Promise<DefinitionQueryResult | null>;
    _getDefinitionForFragmentSpread(query: string, ast: DocumentNode, node: FragmentSpreadNode, filePath: Uri, projectConfig: GraphQLProjectConfig): Promise<DefinitionQueryResult | null>;
    getOutline(documentText: string): Promise<Outline | null>;
}
//# sourceMappingURL=GraphQLLanguageService.d.ts.map