import { DocumentNode, GraphQLSchema, SourceLocation } from 'graphql';
import { Diagnostic, CustomValidationRule } from 'graphql-language-service-types';
import { Range } from 'graphql-language-service-utils';
export declare const SEVERITY: {
    ERROR: number;
    WARNING: number;
    INFORMATION: number;
    HINT: number;
};
export declare function getDiagnostics(query: string, schema?: GraphQLSchema | null | undefined, customRules?: Array<CustomValidationRule>, isRelayCompatMode?: boolean): Array<Diagnostic>;
export declare function validateQuery(ast: DocumentNode, schema?: GraphQLSchema | null | undefined, customRules?: Array<CustomValidationRule>, isRelayCompatMode?: boolean): Array<Diagnostic>;
export declare function getRange(location: SourceLocation, queryText: string): Range;
//# sourceMappingURL=getDiagnostics.d.ts.map