"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
var vscode_languageserver_types_1 = require("vscode-languageserver-types");
var graphql_1 = require("graphql");
var getAutocompleteSuggestions_1 = require("./getAutocompleteSuggestions");
var getHoverInformation_1 = require("./getHoverInformation");
var getDiagnostics_1 = require("./getDiagnostics");
var getDefinition_1 = require("./getDefinition");
var getOutline_1 = require("./getOutline");
var graphql_language_service_utils_1 = require("graphql-language-service-utils");
var FRAGMENT_DEFINITION = graphql_1.Kind.FRAGMENT_DEFINITION, OBJECT_TYPE_DEFINITION = graphql_1.Kind.OBJECT_TYPE_DEFINITION, INTERFACE_TYPE_DEFINITION = graphql_1.Kind.INTERFACE_TYPE_DEFINITION, ENUM_TYPE_DEFINITION = graphql_1.Kind.ENUM_TYPE_DEFINITION, UNION_TYPE_DEFINITION = graphql_1.Kind.UNION_TYPE_DEFINITION, SCALAR_TYPE_DEFINITION = graphql_1.Kind.SCALAR_TYPE_DEFINITION, INPUT_OBJECT_TYPE_DEFINITION = graphql_1.Kind.INPUT_OBJECT_TYPE_DEFINITION, SCALAR_TYPE_EXTENSION = graphql_1.Kind.SCALAR_TYPE_EXTENSION, OBJECT_TYPE_EXTENSION = graphql_1.Kind.OBJECT_TYPE_EXTENSION, INTERFACE_TYPE_EXTENSION = graphql_1.Kind.INTERFACE_TYPE_EXTENSION, UNION_TYPE_EXTENSION = graphql_1.Kind.UNION_TYPE_EXTENSION, ENUM_TYPE_EXTENSION = graphql_1.Kind.ENUM_TYPE_EXTENSION, INPUT_OBJECT_TYPE_EXTENSION = graphql_1.Kind.INPUT_OBJECT_TYPE_EXTENSION, DIRECTIVE_DEFINITION = graphql_1.Kind.DIRECTIVE_DEFINITION, FRAGMENT_SPREAD = graphql_1.Kind.FRAGMENT_SPREAD, OPERATION_DEFINITION = graphql_1.Kind.OPERATION_DEFINITION, NAMED_TYPE = graphql_1.Kind.NAMED_TYPE;
var KIND_TO_SYMBOL_KIND = (_a = {},
    _a[graphql_1.Kind.FIELD] = vscode_languageserver_types_1.SymbolKind.Field,
    _a[graphql_1.Kind.OPERATION_DEFINITION] = vscode_languageserver_types_1.SymbolKind.Class,
    _a[graphql_1.Kind.FRAGMENT_DEFINITION] = vscode_languageserver_types_1.SymbolKind.Class,
    _a[graphql_1.Kind.FRAGMENT_SPREAD] = vscode_languageserver_types_1.SymbolKind.Struct,
    _a[graphql_1.Kind.OBJECT_TYPE_DEFINITION] = vscode_languageserver_types_1.SymbolKind.Class,
    _a[graphql_1.Kind.ENUM_TYPE_DEFINITION] = vscode_languageserver_types_1.SymbolKind.Enum,
    _a[graphql_1.Kind.ENUM_VALUE_DEFINITION] = vscode_languageserver_types_1.SymbolKind.EnumMember,
    _a[graphql_1.Kind.INPUT_OBJECT_TYPE_DEFINITION] = vscode_languageserver_types_1.SymbolKind.Class,
    _a[graphql_1.Kind.INPUT_VALUE_DEFINITION] = vscode_languageserver_types_1.SymbolKind.Field,
    _a[graphql_1.Kind.FIELD_DEFINITION] = vscode_languageserver_types_1.SymbolKind.Field,
    _a[graphql_1.Kind.INTERFACE_TYPE_DEFINITION] = vscode_languageserver_types_1.SymbolKind.Interface,
    _a[graphql_1.Kind.DOCUMENT] = vscode_languageserver_types_1.SymbolKind.File,
    _a.FieldWithArguments = vscode_languageserver_types_1.SymbolKind.Method,
    _a);
function getKind(tree) {
    if (tree.kind === 'FieldDefinition' &&
        tree.children &&
        tree.children.length > 0) {
        return KIND_TO_SYMBOL_KIND.FieldWithArguments;
    }
    return KIND_TO_SYMBOL_KIND[tree.kind];
}
var GraphQLLanguageService = (function () {
    function GraphQLLanguageService(cache) {
        this._graphQLCache = cache;
        this._graphQLConfig = cache.getGraphQLConfig();
    }
    GraphQLLanguageService.prototype.getConfigForURI = function (uri) {
        var config = this._graphQLConfig.getProjectForFile(uri);
        if (config) {
            return config;
        }
        throw Error("No config found for uri: " + uri);
    };
    GraphQLLanguageService.prototype.getDiagnostics = function (query, uri, isRelayCompatMode) {
        return __awaiter(this, void 0, void 0, function () {
            var queryHasExtensions, projectConfig, schemaPath, projectName, extensions, queryAST, range, source, fragmentDefinitions, fragmentDependencies, dependenciesSource, validationAst, customRules, customValidationRules, schema;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        queryHasExtensions = false;
                        projectConfig = this.getConfigForURI(uri);
                        if (!projectConfig) {
                            return [2, []];
                        }
                        schemaPath = projectConfig.schema, projectName = projectConfig.name, extensions = projectConfig.extensions;
                        try {
                            queryAST = graphql_1.parse(query);
                            if (!schemaPath || uri !== schemaPath) {
                                queryHasExtensions = queryAST.definitions.some(function (definition) {
                                    switch (definition.kind) {
                                        case OBJECT_TYPE_DEFINITION:
                                        case INTERFACE_TYPE_DEFINITION:
                                        case ENUM_TYPE_DEFINITION:
                                        case UNION_TYPE_DEFINITION:
                                        case SCALAR_TYPE_DEFINITION:
                                        case INPUT_OBJECT_TYPE_DEFINITION:
                                        case SCALAR_TYPE_EXTENSION:
                                        case OBJECT_TYPE_EXTENSION:
                                        case INTERFACE_TYPE_EXTENSION:
                                        case UNION_TYPE_EXTENSION:
                                        case ENUM_TYPE_EXTENSION:
                                        case INPUT_OBJECT_TYPE_EXTENSION:
                                        case DIRECTIVE_DEFINITION:
                                            return true;
                                    }
                                    return false;
                                });
                            }
                        }
                        catch (error) {
                            range = getDiagnostics_1.getRange(error.locations[0], query);
                            return [2, [
                                    {
                                        severity: getDiagnostics_1.DIAGNOSTIC_SEVERITY.Error,
                                        message: error.message,
                                        source: 'GraphQL: Syntax',
                                        range: range,
                                    },
                                ]];
                        }
                        source = query;
                        return [4, this._graphQLCache.getFragmentDefinitions(projectConfig)];
                    case 1:
                        fragmentDefinitions = _a.sent();
                        return [4, this._graphQLCache.getFragmentDependencies(query, fragmentDefinitions)];
                    case 2:
                        fragmentDependencies = _a.sent();
                        dependenciesSource = fragmentDependencies.reduce(function (prev, cur) { return prev + " " + graphql_1.print(cur.definition); }, '');
                        source = source + " " + dependenciesSource;
                        validationAst = null;
                        try {
                            validationAst = graphql_1.parse(source);
                        }
                        catch (error) {
                            return [2, []];
                        }
                        customRules = null;
                        customValidationRules = extensions.customValidationRules;
                        if (customValidationRules) {
                            customRules = customValidationRules(this._graphQLConfig);
                        }
                        return [4, this._graphQLCache.getSchema(projectName, queryHasExtensions)];
                    case 3:
                        schema = _a.sent();
                        if (!schema) {
                            return [2, []];
                        }
                        return [2, getDiagnostics_1.validateQuery(validationAst, schema, customRules, isRelayCompatMode)];
                }
            });
        });
    };
    GraphQLLanguageService.prototype.getAutocompleteSuggestions = function (query, position, filePath) {
        return __awaiter(this, void 0, void 0, function () {
            var projectConfig, schema;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        projectConfig = this.getConfigForURI(filePath);
                        return [4, this._graphQLCache.getSchema(projectConfig.name)];
                    case 1:
                        schema = _a.sent();
                        if (schema) {
                            return [2, getAutocompleteSuggestions_1.getAutocompleteSuggestions(schema, query, position)];
                        }
                        return [2, []];
                }
            });
        });
    };
    GraphQLLanguageService.prototype.getHoverInformation = function (query, position, filePath) {
        return __awaiter(this, void 0, void 0, function () {
            var projectConfig, schema;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        projectConfig = this.getConfigForURI(filePath);
                        return [4, this._graphQLCache.getSchema(projectConfig.name)];
                    case 1:
                        schema = _a.sent();
                        if (schema) {
                            return [2, getHoverInformation_1.getHoverInformation(schema, query, position)];
                        }
                        return [2, ''];
                }
            });
        });
    };
    GraphQLLanguageService.prototype.getDefinition = function (query, position, filePath) {
        return __awaiter(this, void 0, void 0, function () {
            var projectConfig, ast, node;
            return __generator(this, function (_a) {
                projectConfig = this.getConfigForURI(filePath);
                try {
                    ast = graphql_1.parse(query);
                }
                catch (error) {
                    return [2, null];
                }
                node = graphql_language_service_utils_1.getASTNodeAtPosition(query, ast, position);
                if (node) {
                    switch (node.kind) {
                        case FRAGMENT_SPREAD:
                            return [2, this._getDefinitionForFragmentSpread(query, ast, node, filePath, projectConfig)];
                        case FRAGMENT_DEFINITION:
                        case OPERATION_DEFINITION:
                            return [2, getDefinition_1.getDefinitionQueryResultForDefinitionNode(filePath, query, node)];
                        case NAMED_TYPE:
                            return [2, this._getDefinitionForNamedType(query, ast, node, filePath, projectConfig)];
                    }
                }
                return [2, null];
            });
        });
    };
    GraphQLLanguageService.prototype.getDocumentSymbols = function (document, filePath) {
        return __awaiter(this, void 0, void 0, function () {
            var outline, output, input, _loop_1, state_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.getOutline(document)];
                    case 1:
                        outline = _a.sent();
                        if (!outline) {
                            return [2, []];
                        }
                        output = [];
                        input = outline.outlineTrees.map(function (tree) { return [null, tree]; });
                        _loop_1 = function () {
                            var res = input.pop();
                            if (!res) {
                                return { value: [] };
                            }
                            var parent_1 = res[0], tree = res[1];
                            if (!tree) {
                                return { value: [] };
                            }
                            output.push({
                                name: tree.representativeName,
                                kind: getKind(tree),
                                location: {
                                    uri: filePath,
                                    range: {
                                        start: tree.startPosition,
                                        end: tree.endPosition,
                                    },
                                },
                                containerName: parent_1 ? parent_1.representativeName : undefined,
                            });
                            input.push.apply(input, tree.children.map(function (child) { return [tree, child]; }));
                        };
                        while (input.length > 0) {
                            state_1 = _loop_1();
                            if (typeof state_1 === "object")
                                return [2, state_1.value];
                        }
                        return [2, output];
                }
            });
        });
    };
    GraphQLLanguageService.prototype._getDefinitionForNamedType = function (query, ast, node, filePath, projectConfig) {
        return __awaiter(this, void 0, void 0, function () {
            var objectTypeDefinitions, dependencies, localObjectTypeDefinitions, typeCastedDefs, localOperationDefinationInfos, result;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this._graphQLCache.getObjectTypeDefinitions(projectConfig)];
                    case 1:
                        objectTypeDefinitions = _a.sent();
                        return [4, this._graphQLCache.getObjectTypeDependenciesForAST(ast, objectTypeDefinitions)];
                    case 2:
                        dependencies = _a.sent();
                        localObjectTypeDefinitions = ast.definitions.filter(function (definition) {
                            return definition.kind === OBJECT_TYPE_DEFINITION ||
                                definition.kind === INPUT_OBJECT_TYPE_DEFINITION ||
                                definition.kind === ENUM_TYPE_DEFINITION ||
                                definition.kind === SCALAR_TYPE_DEFINITION ||
                                definition.kind === INTERFACE_TYPE_DEFINITION;
                        });
                        typeCastedDefs = localObjectTypeDefinitions;
                        localOperationDefinationInfos = typeCastedDefs.map(function (definition) { return ({
                            filePath: filePath,
                            content: query,
                            definition: definition,
                        }); });
                        return [4, getDefinition_1.getDefinitionQueryResultForNamedType(query, node, dependencies.concat(localOperationDefinationInfos))];
                    case 3:
                        result = _a.sent();
                        return [2, result];
                }
            });
        });
    };
    GraphQLLanguageService.prototype._getDefinitionForFragmentSpread = function (query, ast, node, filePath, projectConfig) {
        return __awaiter(this, void 0, void 0, function () {
            var fragmentDefinitions, dependencies, localFragDefinitions, typeCastedDefs, localFragInfos, result;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this._graphQLCache.getFragmentDefinitions(projectConfig)];
                    case 1:
                        fragmentDefinitions = _a.sent();
                        return [4, this._graphQLCache.getFragmentDependenciesForAST(ast, fragmentDefinitions)];
                    case 2:
                        dependencies = _a.sent();
                        localFragDefinitions = ast.definitions.filter(function (definition) { return definition.kind === FRAGMENT_DEFINITION; });
                        typeCastedDefs = localFragDefinitions;
                        localFragInfos = typeCastedDefs.map(function (definition) { return ({
                            filePath: filePath,
                            content: query,
                            definition: definition,
                        }); });
                        return [4, getDefinition_1.getDefinitionQueryResultForFragmentSpread(query, node, dependencies.concat(localFragInfos))];
                    case 3:
                        result = _a.sent();
                        return [2, result];
                }
            });
        });
    };
    GraphQLLanguageService.prototype.getOutline = function (documentText) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, getOutline_1.getOutline(documentText)];
            });
        });
    };
    return GraphQLLanguageService;
}());
exports.GraphQLLanguageService = GraphQLLanguageService;
//# sourceMappingURL=GraphQLLanguageService.js.map