"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var graphql_1 = require("graphql");
var graphql_language_service_utils_1 = require("graphql-language-service-utils");
var INLINE_FRAGMENT = graphql_1.Kind.INLINE_FRAGMENT;
var OUTLINEABLE_KINDS = {
    Field: true,
    OperationDefinition: true,
    Document: true,
    SelectionSet: true,
    Name: true,
    FragmentDefinition: true,
    FragmentSpread: true,
    InlineFragment: true,
    ObjectTypeDefinition: true,
    InputObjectTypeDefinition: true,
    InterfaceTypeDefinition: true,
    EnumTypeDefinition: true,
    EnumValueDefinition: true,
    InputValueDefinition: true,
    FieldDefinition: true,
};
function getOutline(documentText) {
    var ast;
    try {
        ast = graphql_1.parse(documentText);
    }
    catch (error) {
        return null;
    }
    var visitorFns = outlineTreeConverter(documentText);
    var outlineTrees = graphql_1.visit(ast, {
        leave: function (node) {
            if (visitorFns !== undefined && node.kind in visitorFns) {
                return visitorFns[node.kind](node);
            }
            return null;
        },
    });
    return { outlineTrees: outlineTrees };
}
exports.getOutline = getOutline;
function outlineTreeConverter(docText) {
    var meta = function (node) {
        return {
            representativeName: node.name,
            startPosition: graphql_language_service_utils_1.offsetToPosition(docText, node.loc.start),
            endPosition: graphql_language_service_utils_1.offsetToPosition(docText, node.loc.end),
            kind: node.kind,
            children: node.selectionSet || node.fields || node.values || node.arguments || [],
        };
    };
    return {
        Field: function (node) {
            var tokenizedText = node.alias
                ? [buildToken('plain', node.alias), buildToken('plain', ': ')]
                : [];
            tokenizedText.push(buildToken('plain', node.name));
            return __assign({ tokenizedText: tokenizedText }, meta(node));
        },
        OperationDefinition: function (node) { return (__assign({ tokenizedText: [
                buildToken('keyword', node.operation),
                buildToken('whitespace', ' '),
                buildToken('class-name', node.name),
            ] }, meta(node))); },
        Document: function (node) { return node.definitions; },
        SelectionSet: function (node) {
            return concatMap(node.selections, function (child) {
                return child.kind === INLINE_FRAGMENT ? child.selectionSet : child;
            });
        },
        Name: function (node) { return node.value; },
        FragmentDefinition: function (node) { return (__assign({ tokenizedText: [
                buildToken('keyword', 'fragment'),
                buildToken('whitespace', ' '),
                buildToken('class-name', node.name),
            ] }, meta(node))); },
        InterfaceTypeDefinition: function (node) { return (__assign({ tokenizedText: [
                buildToken('keyword', 'interface'),
                buildToken('whitespace', ' '),
                buildToken('class-name', node.name),
            ] }, meta(node))); },
        EnumTypeDefinition: function (node) { return (__assign({ tokenizedText: [
                buildToken('keyword', 'enum'),
                buildToken('whitespace', ' '),
                buildToken('class-name', node.name),
            ] }, meta(node))); },
        EnumValueDefinition: function (node) { return (__assign({ tokenizedText: [buildToken('plain', node.name)] }, meta(node))); },
        ObjectTypeDefinition: function (node) { return (__assign({ tokenizedText: [
                buildToken('keyword', 'type'),
                buildToken('whitespace', ' '),
                buildToken('class-name', node.name),
            ] }, meta(node))); },
        InputObjectTypeDefinition: function (node) { return (__assign({ tokenizedText: [
                buildToken('keyword', 'input'),
                buildToken('whitespace', ' '),
                buildToken('class-name', node.name),
            ] }, meta(node))); },
        FragmentSpread: function (node) { return (__assign({ tokenizedText: [
                buildToken('plain', '...'),
                buildToken('class-name', node.name),
            ] }, meta(node))); },
        InputValueDefinition: function (node) {
            return __assign({ tokenizedText: [buildToken('plain', node.name)] }, meta(node));
        },
        FieldDefinition: function (node) {
            return __assign({ tokenizedText: [buildToken('plain', node.name)] }, meta(node));
        },
        InlineFragment: function (node) { return node.selectionSet; },
    };
}
function buildToken(kind, value) {
    return { kind: kind, value: value };
}
function concatMap(arr, fn) {
    var res = [];
    for (var i = 0; i < arr.length; i++) {
        var x = fn(arr[i], i);
        if (Array.isArray(x)) {
            res.push.apply(res, x);
        }
        else {
            res.push(x);
        }
    }
    return res;
}
//# sourceMappingURL=getOutline.js.map