import { isCompositeType } from 'graphql';
import { SchemaMetaFieldDef, TypeMetaFieldDef, TypeNameMetaFieldDef, } from 'graphql/type/introspection';
export function getDefinitionState(tokenState) {
    var definitionState;
    forEachState(tokenState, function (state) {
        switch (state.kind) {
            case 'Query':
            case 'ShortQuery':
            case 'Mutation':
            case 'Subscription':
            case 'FragmentDefinition':
                definitionState = state;
                break;
        }
    });
    return definitionState;
}
export function getFieldDef(schema, type, fieldName) {
    if (fieldName === SchemaMetaFieldDef.name && schema.getQueryType() === type) {
        return SchemaMetaFieldDef;
    }
    if (fieldName === TypeMetaFieldDef.name && schema.getQueryType() === type) {
        return TypeMetaFieldDef;
    }
    if (fieldName === TypeNameMetaFieldDef.name && isCompositeType(type)) {
        return TypeNameMetaFieldDef;
    }
    if ('getFields' in type) {
        return type.getFields()[fieldName];
    }
    return null;
}
export function forEachState(stack, fn) {
    var reverseStateStack = [];
    var state = stack;
    while (state && state.kind) {
        reverseStateStack.push(state);
        state = state.prevState;
    }
    for (var i = reverseStateStack.length - 1; i >= 0; i--) {
        fn(reverseStateStack[i]);
    }
}
export function objectValues(object) {
    var keys = Object.keys(object);
    var len = keys.length;
    var values = new Array(len);
    for (var i = 0; i < len; ++i) {
        values[i] = object[keys[i]];
    }
    return values;
}
export function hintList(token, list) {
    return filterAndSortList(list, normalizeText(token.string));
}
function filterAndSortList(list, text) {
    if (!text) {
        return filterNonEmpty(list, function (entry) { return !entry.isDeprecated; });
    }
    var byProximity = list.map(function (entry) { return ({
        proximity: getProximity(normalizeText(entry.label), text),
        entry: entry,
    }); });
    var conciseMatches = filterNonEmpty(filterNonEmpty(byProximity, function (pair) { return pair.proximity <= 2; }), function (pair) { return !pair.entry.isDeprecated; });
    var sortedMatches = conciseMatches.sort(function (a, b) {
        return (a.entry.isDeprecated ? 1 : 0) - (b.entry.isDeprecated ? 1 : 0) ||
            a.proximity - b.proximity ||
            a.entry.label.length - b.entry.label.length;
    });
    return sortedMatches.map(function (pair) { return pair.entry; });
}
function filterNonEmpty(array, predicate) {
    var filtered = array.filter(predicate);
    return filtered.length === 0 ? array : filtered;
}
function normalizeText(text) {
    return text.toLowerCase().replace(/\W/g, '');
}
function getProximity(suggestion, text) {
    var proximity = lexicalDistance(text, suggestion);
    if (suggestion.length > text.length) {
        proximity -= suggestion.length - text.length - 1;
        proximity += suggestion.indexOf(text) === 0 ? 0 : 0.5;
    }
    return proximity;
}
function lexicalDistance(a, b) {
    var i;
    var j;
    var d = [];
    var aLength = a.length;
    var bLength = b.length;
    for (i = 0; i <= aLength; i++) {
        d[i] = [i];
    }
    for (j = 1; j <= bLength; j++) {
        d[0][j] = j;
    }
    for (i = 1; i <= aLength; i++) {
        for (j = 1; j <= bLength; j++) {
            var cost = a[i - 1] === b[j - 1] ? 0 : 1;
            d[i][j] = Math.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            if (i > 1 && j > 1 && a[i - 1] === b[j - 2] && a[i - 2] === b[j - 1]) {
                d[i][j] = Math.min(d[i][j], d[i - 2][j - 2] + cost);
            }
        }
    }
    return d[aLength][bLength];
}
//# sourceMappingURL=autocompleteUtils.js.map