var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
import { locToRange, offsetToPosition } from 'graphql-language-service-utils';
import assert from 'assert';
export var LANGUAGE = 'GraphQL';
function getRange(text, node) {
    var location = node.loc;
    assert(location, 'Expected ASTNode to have a location.');
    return locToRange(text, location);
}
function getPosition(text, node) {
    var location = node.loc;
    assert(location, 'Expected ASTNode to have a location.');
    return offsetToPosition(text, location.start);
}
export function getDefinitionQueryResultForNamedType(text, node, dependencies) {
    return __awaiter(this, void 0, void 0, function () {
        var name, defNodes, definitions;
        return __generator(this, function (_a) {
            name = node.name.value;
            defNodes = dependencies.filter(function (_a) {
                var definition = _a.definition;
                return definition.name && definition.name.value === name;
            });
            if (defNodes.length === 0) {
                throw Error("Definition not found for GraphQL type " + name);
            }
            definitions = defNodes.map(function (_a) {
                var filePath = _a.filePath, content = _a.content, definition = _a.definition;
                return getDefinitionForNodeDefinition(filePath || '', content, definition);
            });
            return [2, {
                    definitions: definitions,
                    queryRange: definitions.map(function (_) { return getRange(text, node); }),
                }];
        });
    });
}
export function getDefinitionQueryResultForFragmentSpread(text, fragment, dependencies) {
    return __awaiter(this, void 0, void 0, function () {
        var name, defNodes, definitions;
        return __generator(this, function (_a) {
            name = fragment.name.value;
            defNodes = dependencies.filter(function (_a) {
                var definition = _a.definition;
                return definition.name.value === name;
            });
            if (defNodes.length === 0) {
                throw Error("Definition not found for GraphQL fragment " + name);
            }
            definitions = defNodes.map(function (_a) {
                var filePath = _a.filePath, content = _a.content, definition = _a.definition;
                return getDefinitionForFragmentDefinition(filePath || '', content, definition);
            });
            return [2, {
                    definitions: definitions,
                    queryRange: definitions.map(function (_) { return getRange(text, fragment); }),
                }];
        });
    });
}
export function getDefinitionQueryResultForDefinitionNode(path, text, definition) {
    return {
        definitions: [getDefinitionForFragmentDefinition(path, text, definition)],
        queryRange: definition.name ? [getRange(text, definition.name)] : [],
    };
}
function getDefinitionForFragmentDefinition(path, text, definition) {
    var name = definition.name;
    if (!name) {
        throw Error('Expected ASTNode to have a Name.');
    }
    return {
        path: path,
        position: getPosition(text, definition),
        range: getRange(text, definition),
        name: name.value || '',
        language: LANGUAGE,
        projectRoot: path,
    };
}
function getDefinitionForNodeDefinition(path, text, definition) {
    var name = definition.name;
    assert(name, 'Expected ASTNode to have a Name.');
    return {
        path: path,
        position: getPosition(text, definition),
        range: getRange(text, definition),
        name: name.value || '',
        language: LANGUAGE,
        projectRoot: path,
    };
}
//# sourceMappingURL=getDefinition.js.map