import type CodeMirror from 'codemirror';
import { FragmentDefinitionNode, GraphQLDirective, GraphQLSchema } from 'graphql';
import { CompletionItem, AllTypeInfo, IPosition } from 'graphql-language-service-types';
import { CharacterStream, ContextToken, State } from 'graphql-language-service-parser';
export declare function getAutocompleteSuggestions(schema: GraphQLSchema, queryText: string, cursor: IPosition, contextToken?: CodeMirror.Token, fragmentDefs?: FragmentDefinitionNode[] | string): Array<CompletionItem>;
export declare function getVariableCompletions(queryText: string, schema: GraphQLSchema, forcePrefix?: boolean): CompletionItem[];
export declare function getFragmentDefinitions(queryText: string): Array<FragmentDefinitionNode>;
export declare function getTokenAtPosition(queryText: string, cursor: IPosition): ContextToken;
declare type callbackFnType = (stream: CharacterStream, state: State, style: string, index: number) => void | 'BREAK';
export declare function runOnlineParser(queryText: string, callback: callbackFnType): ContextToken;
export declare function canUseDirective(state: State['prevState'], directive: GraphQLDirective): boolean;
export declare function getTypeInfo(schema: GraphQLSchema, tokenState: State): AllTypeInfo;
export {};
//# sourceMappingURL=getAutocompleteSuggestions.d.ts.map