import { Kind } from 'graphql';
import { Maybe } from 'graphql-language-service-types';
import CharacterStream from './CharacterStream';
export declare type ContextToken = {
    start: number;
    end: number;
    string: string;
    state: State;
    style?: string;
};
export declare type ContextTokenForCodeMirror = {
    start: number;
    end: number;
    string: string;
    type: string | null;
    state: State;
};
export declare type ContextTokenUnion = ContextToken | ContextTokenForCodeMirror;
export declare type RuleOrString = Rule | string;
export declare type ParseRule = RuleOrString[] | ((token: Token, stream: CharacterStream) => string | null | void);
export declare type Token = {
    kind: string;
    value: string;
};
export declare type Rule = {
    style?: string;
    match?: (token: Token) => boolean;
    update?: (state: State, token: Token) => void;
    separator?: string | Rule;
    isList?: boolean;
    ofRule?: Rule | string;
};
export declare type State = {
    level: number;
    levels?: number[];
    prevState: Maybe<State>;
    rule: Maybe<ParseRule>;
    kind: Maybe<RuleKind>;
    name: Maybe<string>;
    type: Maybe<string>;
    step: number;
    needsSeperator: boolean;
    needsAdvance?: boolean;
    indentLevel?: number;
    inBlockstring?: boolean;
};
export declare const AdditionalRuleKinds: _AdditionalRuleKinds;
export declare type _AdditionalRuleKinds = {
    ALIASED_FIELD: 'AliasedField';
    ARGUMENTS: 'Arguments';
    SHORT_QUERY: 'ShortQuery';
    QUERY: 'Query';
    MUTATION: 'Mutation';
    SUBSCRIPTION: 'Subscription';
    TYPE_CONDITION: 'TypeCondition';
    INVALID: 'Invalid';
    COMMENT: 'Comment';
    SCHEMA_DEF: 'SchemaDef';
    SCALAR_DEF: 'ScalarDef';
    OBJECT_TYPE_DEF: 'ObjectTypeDef';
    OBJECT_VALUE: 'ObjectValue';
    LIST_VALUE: 'ListValue';
    INTERFACE_DEF: 'InterfaceDef';
    UNION_DEF: 'UnionDef';
    ENUM_DEF: 'EnumDef';
    ENUM_VALUE: 'EnumValue';
    FIELD_DEF: 'FieldDef';
    INPUT_DEF: 'InputDef';
    INPUT_VALUE_DEF: 'InputValueDef';
    ARGUMENTS_DEF: 'ArgumentsDef';
    EXTEND_DEF: 'ExtendDef';
    DIRECTIVE_DEF: 'DirectiveDef';
    IMPLEMENTS: 'Implements';
    VARIABLE_DEFINITIONS: 'VariableDefinitions';
    TYPE: 'Type';
};
export declare const RuleKinds: {
    ALIASED_FIELD: 'AliasedField';
    ARGUMENTS: 'Arguments';
    SHORT_QUERY: 'ShortQuery';
    QUERY: 'Query';
    MUTATION: 'Mutation';
    SUBSCRIPTION: 'Subscription';
    TYPE_CONDITION: 'TypeCondition';
    INVALID: 'Invalid';
    COMMENT: 'Comment';
    SCHEMA_DEF: 'SchemaDef';
    SCALAR_DEF: 'ScalarDef';
    OBJECT_TYPE_DEF: 'ObjectTypeDef';
    OBJECT_VALUE: 'ObjectValue';
    LIST_VALUE: 'ListValue';
    INTERFACE_DEF: 'InterfaceDef';
    UNION_DEF: 'UnionDef';
    ENUM_DEF: 'EnumDef';
    ENUM_VALUE: 'EnumValue';
    FIELD_DEF: 'FieldDef';
    INPUT_DEF: 'InputDef';
    INPUT_VALUE_DEF: 'InputValueDef';
    ARGUMENTS_DEF: 'ArgumentsDef';
    EXTEND_DEF: 'ExtendDef';
    DIRECTIVE_DEF: 'DirectiveDef';
    IMPLEMENTS: 'Implements';
    VARIABLE_DEFINITIONS: 'VariableDefinitions';
    TYPE: 'Type';
    NAME: Kind.NAME;
    DOCUMENT: Kind.DOCUMENT;
    OPERATION_DEFINITION: Kind.OPERATION_DEFINITION;
    VARIABLE_DEFINITION: Kind.VARIABLE_DEFINITION;
    SELECTION_SET: Kind.SELECTION_SET;
    FIELD: Kind.FIELD;
    ARGUMENT: Kind.ARGUMENT;
    FRAGMENT_SPREAD: Kind.FRAGMENT_SPREAD;
    INLINE_FRAGMENT: Kind.INLINE_FRAGMENT;
    FRAGMENT_DEFINITION: Kind.FRAGMENT_DEFINITION;
    VARIABLE: Kind.VARIABLE;
    INT: Kind.INT;
    FLOAT: Kind.FLOAT;
    STRING: Kind.STRING;
    BOOLEAN: Kind.BOOLEAN;
    NULL: Kind.NULL;
    ENUM: Kind.ENUM;
    LIST: Kind.LIST;
    OBJECT: Kind.OBJECT;
    OBJECT_FIELD: Kind.OBJECT_FIELD;
    DIRECTIVE: Kind.DIRECTIVE;
    NAMED_TYPE: Kind.NAMED_TYPE;
    LIST_TYPE: Kind.LIST_TYPE;
    NON_NULL_TYPE: Kind.NON_NULL_TYPE;
    SCHEMA_DEFINITION: Kind.SCHEMA_DEFINITION;
    OPERATION_TYPE_DEFINITION: Kind.OPERATION_TYPE_DEFINITION;
    SCALAR_TYPE_DEFINITION: Kind.SCALAR_TYPE_DEFINITION;
    OBJECT_TYPE_DEFINITION: Kind.OBJECT_TYPE_DEFINITION;
    FIELD_DEFINITION: Kind.FIELD_DEFINITION;
    INPUT_VALUE_DEFINITION: Kind.INPUT_VALUE_DEFINITION;
    INTERFACE_TYPE_DEFINITION: Kind.INTERFACE_TYPE_DEFINITION;
    UNION_TYPE_DEFINITION: Kind.UNION_TYPE_DEFINITION;
    ENUM_TYPE_DEFINITION: Kind.ENUM_TYPE_DEFINITION;
    ENUM_VALUE_DEFINITION: Kind.ENUM_VALUE_DEFINITION;
    INPUT_OBJECT_TYPE_DEFINITION: Kind.INPUT_OBJECT_TYPE_DEFINITION;
    DIRECTIVE_DEFINITION: Kind.DIRECTIVE_DEFINITION;
    SCHEMA_EXTENSION: Kind.SCHEMA_EXTENSION;
    SCALAR_TYPE_EXTENSION: Kind.SCALAR_TYPE_EXTENSION;
    OBJECT_TYPE_EXTENSION: Kind.OBJECT_TYPE_EXTENSION;
    INTERFACE_TYPE_EXTENSION: Kind.INTERFACE_TYPE_EXTENSION;
    UNION_TYPE_EXTENSION: Kind.UNION_TYPE_EXTENSION;
    ENUM_TYPE_EXTENSION: Kind.ENUM_TYPE_EXTENSION;
    INPUT_OBJECT_TYPE_EXTENSION: Kind.INPUT_OBJECT_TYPE_EXTENSION;
};
export declare type _RuleKinds = typeof Kind & typeof AdditionalRuleKinds;
export declare type RuleKind = _RuleKinds[keyof _RuleKinds];
export declare type RuleKindEnum = RuleKind;
export declare type TokenPattern = string | ((char: string) => boolean) | RegExp;
export interface CharacterStreamInterface {
    getStartOfToken: () => number;
    getCurrentPosition: () => number;
    eol: () => boolean;
    sol: () => boolean;
    peek: () => string | null;
    next: () => string;
    eat: (pattern: TokenPattern) => string | undefined;
    eatWhile: (match: TokenPattern) => boolean;
    eatSpace: () => boolean;
    skipToEnd: () => void;
    skipTo: (position: number) => void;
    match: (pattern: TokenPattern, consume?: Maybe<boolean>, caseFold?: Maybe<boolean>) => string[] | boolean;
    backUp: (num: number) => void;
    column: () => number;
    indentation: () => number;
    current: () => string;
}
//# sourceMappingURL=types.d.ts.map