"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var CharacterStream = (function () {
    function CharacterStream(sourceText) {
        var _this = this;
        this.getStartOfToken = function () { return _this._start; };
        this.getCurrentPosition = function () { return _this._pos; };
        this.eol = function () { return _this._sourceText.length === _this._pos; };
        this.sol = function () { return _this._pos === 0; };
        this.peek = function () {
            return _this._sourceText.charAt(_this._pos)
                ? _this._sourceText.charAt(_this._pos)
                : null;
        };
        this.next = function () {
            var char = _this._sourceText.charAt(_this._pos);
            _this._pos++;
            return char;
        };
        this.eat = function (pattern) {
            var isMatched = _this._testNextCharacter(pattern);
            if (isMatched) {
                _this._start = _this._pos;
                _this._pos++;
                return _this._sourceText.charAt(_this._pos - 1);
            }
            return undefined;
        };
        this.eatWhile = function (match) {
            var isMatched = _this._testNextCharacter(match);
            var didEat = false;
            if (isMatched) {
                didEat = isMatched;
                _this._start = _this._pos;
            }
            while (isMatched) {
                _this._pos++;
                isMatched = _this._testNextCharacter(match);
                didEat = true;
            }
            return didEat;
        };
        this.eatSpace = function () { return _this.eatWhile(/[\s\u00a0]/); };
        this.skipToEnd = function () {
            _this._pos = _this._sourceText.length;
        };
        this.skipTo = function (position) {
            _this._pos = position;
        };
        this.match = function (pattern, consume, caseFold) {
            if (consume === void 0) { consume = true; }
            if (caseFold === void 0) { caseFold = false; }
            var token = null;
            var match = null;
            if (typeof pattern === 'string') {
                var regex = new RegExp(pattern, caseFold ? 'i' : 'g');
                match = regex.test(_this._sourceText.substr(_this._pos, pattern.length));
                token = pattern;
            }
            else if (pattern instanceof RegExp) {
                match = _this._sourceText.slice(_this._pos).match(pattern);
                token = match && match[0];
            }
            if (match != null) {
                if (typeof pattern === 'string' ||
                    (match instanceof Array &&
                        _this._sourceText.startsWith(match[0], _this._pos))) {
                    if (consume) {
                        _this._start = _this._pos;
                        if (token && token.length) {
                            _this._pos += token.length;
                        }
                    }
                    return match;
                }
            }
            return false;
        };
        this.backUp = function (num) {
            _this._pos -= num;
        };
        this.column = function () { return _this._pos; };
        this.indentation = function () {
            var match = _this._sourceText.match(/\s*/);
            var indent = 0;
            if (match && match.length === 0) {
                var whitespaces = match[0];
                var pos = 0;
                while (whitespaces.length > pos) {
                    if (whitespaces.charCodeAt(pos) === 9) {
                        indent += 2;
                    }
                    else {
                        indent++;
                    }
                    pos++;
                }
            }
            return indent;
        };
        this.current = function () { return _this._sourceText.slice(_this._start, _this._pos); };
        this._start = 0;
        this._pos = 0;
        this._sourceText = sourceText;
    }
    CharacterStream.prototype._testNextCharacter = function (pattern) {
        var character = this._sourceText.charAt(this._pos);
        var isMatched = false;
        if (typeof pattern === 'string') {
            isMatched = character === pattern;
        }
        else {
            isMatched =
                pattern instanceof RegExp
                    ? pattern.test(character)
                    : pattern(character);
        }
        return isMatched;
    };
    return CharacterStream;
}());
exports.default = CharacterStream;
//# sourceMappingURL=CharacterStream.js.map