"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function opt(ofRule) {
    return { ofRule: ofRule };
}
exports.opt = opt;
function list(ofRule, separator) {
    return { ofRule: ofRule, isList: true, separator: separator };
}
exports.list = list;
function butNot(rule, exclusions) {
    var ruleMatch = rule.match;
    rule.match = function (token) {
        var check = false;
        if (ruleMatch) {
            check = ruleMatch(token);
        }
        return (check &&
            exclusions.every(function (exclusion) { return exclusion.match && !exclusion.match(token); }));
    };
    return rule;
}
exports.butNot = butNot;
function t(kind, style) {
    return { style: style, match: function (token) { return token.kind === kind; } };
}
exports.t = t;
function p(value, style) {
    return {
        style: style || 'punctuation',
        match: function (token) {
            return token.kind === 'Punctuation' && token.value === value;
        },
    };
}
exports.p = p;
//# sourceMappingURL=RuleHelpers.js.map