"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var Rules_1 = require("./Rules");
function onlineParser(options) {
    if (options === void 0) { options = {
        eatWhitespace: function (stream) { return stream.eatWhile(Rules_1.isIgnored); },
        lexRules: Rules_1.LexRules,
        parseRules: Rules_1.ParseRules,
        editorConfig: {},
    }; }
    return {
        startState: function () {
            var initialState = {
                level: 0,
                step: 0,
                name: null,
                kind: null,
                type: null,
                rule: null,
                needsSeperator: false,
                prevState: null,
            };
            pushRule(options.parseRules, initialState, 'Document');
            return initialState;
        },
        token: function (stream, state) {
            return getToken(stream, state, options);
        },
    };
}
exports.default = onlineParser;
function getToken(stream, state, options) {
    var lexRules = options.lexRules, parseRules = options.parseRules, eatWhitespace = options.eatWhitespace, editorConfig = options.editorConfig;
    if (state.rule && state.rule.length === 0) {
        popRule(state);
    }
    else if (state.needsAdvance) {
        state.needsAdvance = false;
        advanceRule(state, true);
    }
    if (stream.sol()) {
        var tabSize = (editorConfig && editorConfig.tabSize) || 2;
        state.indentLevel = Math.floor(stream.indentation() / tabSize);
    }
    if (eatWhitespace(stream)) {
        return 'ws';
    }
    var token = lex(lexRules, stream);
    if (!token) {
        var matchedSomething = stream.match(/\S+/);
        if (!matchedSomething) {
            stream.match(/\s/);
        }
        pushRule(SpecialParseRules, state, 'Invalid');
        return 'invalidchar';
    }
    if (token.kind === 'Comment') {
        pushRule(SpecialParseRules, state, 'Comment');
        return 'comment';
    }
    var backupState = assign({}, state);
    if (token.kind === 'Punctuation') {
        if (/^[{([]/.test(token.value)) {
            if (state.indentLevel !== undefined) {
                state.levels = (state.levels || []).concat(state.indentLevel + 1);
            }
        }
        else if (/^[})\]]/.test(token.value)) {
            var levels = (state.levels = (state.levels || []).slice(0, -1));
            if (state.indentLevel) {
                if (levels.length > 0 &&
                    levels[levels.length - 1] < state.indentLevel) {
                    state.indentLevel = levels[levels.length - 1];
                }
            }
        }
    }
    while (state.rule) {
        var expected = typeof state.rule === 'function'
            ? state.step === 0
                ? state.rule(token, stream)
                : null
            : state.rule[state.step];
        if (state.needsSeperator) {
            expected = expected && expected.separator;
        }
        if (expected) {
            if (expected.ofRule) {
                expected = expected.ofRule;
            }
            if (typeof expected === 'string') {
                pushRule(parseRules, state, expected);
                continue;
            }
            if (expected.match && expected.match(token)) {
                if (expected.update) {
                    expected.update(state, token);
                }
                if (token.kind === 'Punctuation') {
                    advanceRule(state, true);
                }
                else {
                    state.needsAdvance = true;
                }
                return expected.style;
            }
        }
        unsuccessful(state);
    }
    assign(state, backupState);
    pushRule(SpecialParseRules, state, 'Invalid');
    return 'invalidchar';
}
function assign(to, from) {
    var keys = Object.keys(from);
    for (var i = 0; i < keys.length; i++) {
        to[keys[i]] = from[keys[i]];
    }
    return to;
}
var SpecialParseRules = {
    Invalid: [],
    Comment: [],
};
function pushRule(rules, state, ruleKind) {
    if (!rules[ruleKind]) {
        throw new TypeError('Unknown rule: ' + ruleKind);
    }
    state.prevState = __assign({}, state);
    state.kind = ruleKind;
    state.name = null;
    state.type = null;
    state.rule = rules[ruleKind];
    state.step = 0;
    state.needsSeperator = false;
}
function popRule(state) {
    if (!state.prevState) {
        return;
    }
    state.kind = state.prevState.kind;
    state.name = state.prevState.name;
    state.type = state.prevState.type;
    state.rule = state.prevState.rule;
    state.step = state.prevState.step;
    state.needsSeperator = state.prevState.needsSeperator;
    state.prevState = state.prevState.prevState;
}
function advanceRule(state, successful) {
    if (isList(state) && state.rule) {
        var step = state.rule[state.step];
        if (step.separator) {
            var separator = step.separator;
            state.needsSeperator = !state.needsSeperator;
            if (!state.needsSeperator && separator.ofRule) {
                return;
            }
        }
        if (successful) {
            return;
        }
    }
    state.needsSeperator = false;
    state.step++;
    while (state.rule &&
        !(Array.isArray(state.rule) && state.step < state.rule.length)) {
        popRule(state);
        if (state.rule) {
            if (isList(state)) {
                if (state.rule && state.rule[state.step].separator) {
                    state.needsSeperator = !state.needsSeperator;
                }
            }
            else {
                state.needsSeperator = false;
                state.step++;
            }
        }
    }
}
function isList(state) {
    var step = Array.isArray(state.rule) &&
        typeof state.rule[state.step] !== 'string' &&
        state.rule[state.step];
    return step && step.isList;
}
function unsuccessful(state) {
    while (state.rule &&
        !(Array.isArray(state.rule) && state.rule[state.step].ofRule)) {
        popRule(state);
    }
    if (state.rule) {
        advanceRule(state, false);
    }
}
function lex(lexRules, stream) {
    var kinds = Object.keys(lexRules);
    for (var i = 0; i < kinds.length; i++) {
        var match = stream.match(lexRules[kinds[i]]);
        if (match && match instanceof Array) {
            return { kind: kinds[i], value: match[0] };
        }
    }
}
//# sourceMappingURL=onlineParser.js.map