export function opt(ofRule) {
    return { ofRule: ofRule };
}
export function list(ofRule, separator) {
    return { ofRule: ofRule, isList: true, separator: separator };
}
export function butNot(rule, exclusions) {
    var ruleMatch = rule.match;
    rule.match = function (token) {
        var check = false;
        if (ruleMatch) {
            check = ruleMatch(token);
        }
        return (check &&
            exclusions.every(function (exclusion) { return exclusion.match && !exclusion.match(token); }));
    };
    return rule;
}
export function t(kind, style) {
    return { style: style, match: function (token) { return token.kind === kind; } };
}
export function p(value, style) {
    return {
        style: style || 'punctuation',
        match: function (token) {
            return token.kind === 'Punctuation' && token.value === value;
        },
    };
}
//# sourceMappingURL=RuleHelpers.js.map