'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateWithCustomRules = validateWithCustomRules;

var _graphql = require('graphql');

/**
 * Validate a GraphQL Document optionally with custom validation rules.
 */
function validateWithCustomRules(schema, ast, customRules) {
  // Because every fragment is considered for determing model subsets that may
  // be used anywhere in the codebase they're all technically "used" by clients
  // of graphql-data. So we remove this rule from the validators.
  var _require = require('graphql/validation/rules/NoUnusedFragments'),
      NoUnusedFragments = _require.NoUnusedFragments;

  var rules = _graphql.specifiedRules.filter(function (rule) {
    return rule !== NoUnusedFragments;
  });

  var typeInfo = new _graphql.TypeInfo(schema);
  if (customRules) {
    Array.prototype.push.apply(rules, customRules);
  }

  var errors = (0, _graphql.validate)(schema, ast, rules, typeInfo);

  if (errors.length > 0) {
    return errors;
  }

  return [];
} /**
   *  Copyright (c) Facebook, Inc.
   *  All rights reserved.
   *
   *  This source code is licensed under the license found in the
   *  LICENSE file in the root directory of this source tree.
   *
   *  
   */