"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const graphql_1 = require("graphql");
function validateWithCustomRules(schema, ast, customRules, isRelayCompatMode) {
    const { NoUnusedFragments, } = require('graphql/validation/rules/NoUnusedFragments');
    const { ExecutableDefinitions, } = require('graphql/validation/rules/ExecutableDefinitions');
    const rulesToSkip = [NoUnusedFragments, ExecutableDefinitions];
    if (isRelayCompatMode) {
        const { KnownFragmentNames, } = require('graphql/validation/rules/KnownFragmentNames');
        rulesToSkip.push(KnownFragmentNames);
    }
    const rules = graphql_1.specifiedRules.filter(rule => !rulesToSkip.some(r => r === rule));
    const typeInfo = new graphql_1.TypeInfo(schema);
    if (customRules) {
        Array.prototype.push.apply(rules, customRules);
    }
    const errors = graphql_1.validate(schema, ast, rules, typeInfo);
    if (errors.length > 0) {
        return errors.filter(error => {
            if (error.message.indexOf('Unknown directive') === -1) {
                return true;
            }
            if (error.nodes && error.nodes[0]) {
                const node = error.nodes[0];
                return !(node.name &&
                    node.name.value === 'arguments' ||
                    node.name.value === 'argumentDefinitions');
            }
        });
    }
    return [];
}
exports.validateWithCustomRules = validateWithCustomRules;
//# sourceMappingURL=validateWithCustomRules.js.map