"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Range = (function () {
    function Range(start, end) {
        var _this = this;
        this.containsPosition = function (position) {
            if (_this.start.line === position.line) {
                return _this.start.character <= position.character;
            }
            else if (_this.end.line === position.line) {
                return _this.end.character >= position.character;
            }
            else {
                return _this.start.line <= position.line && _this.end.line >= position.line;
            }
        };
        this.start = start;
        this.end = end;
    }
    Range.prototype.setStart = function (line, character) {
        this.start = new Position(line, character);
    };
    Range.prototype.setEnd = function (line, character) {
        this.end = new Position(line, character);
    };
    return Range;
}());
exports.Range = Range;
var Position = (function () {
    function Position(line, character) {
        var _this = this;
        this.lessThanOrEqualTo = function (position) {
            return _this.line < position.line ||
                (_this.line === position.line && _this.character <= position.character);
        };
        this.line = line;
        this.character = character;
    }
    Position.prototype.setLine = function (line) {
        this.line = line;
    };
    Position.prototype.setCharacter = function (character) {
        this.character = character;
    };
    return Position;
}());
exports.Position = Position;
function offsetToPosition(text, loc) {
    var EOL = '\n';
    var buf = text.slice(0, loc);
    var lines = buf.split(EOL).length - 1;
    var lastLineIndex = buf.lastIndexOf(EOL);
    return new Position(lines, loc - lastLineIndex - 1);
}
exports.offsetToPosition = offsetToPosition;
function locToRange(text, loc) {
    var start = offsetToPosition(text, loc.start);
    var end = offsetToPosition(text, loc.end);
    return new Range(start, end);
}
exports.locToRange = locToRange;
//# sourceMappingURL=Range.js.map