"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var graphql_1 = require("graphql");
function getASTNodeAtPosition(query, ast, point) {
    var offset = pointToOffset(query, point);
    var nodeContainingPosition;
    graphql_1.visit(ast, {
        enter: function (node) {
            if (node.kind !== 'Name' &&
                node.loc &&
                node.loc.start <= offset &&
                offset <= node.loc.end) {
                nodeContainingPosition = node;
            }
            else {
                return false;
            }
        },
        leave: function (node) {
            if (node.loc && node.loc.start <= offset && offset <= node.loc.end) {
                return false;
            }
        },
    });
    return nodeContainingPosition;
}
exports.getASTNodeAtPosition = getASTNodeAtPosition;
function pointToOffset(text, point) {
    var linesUntilPosition = text.split('\n').slice(0, point.line);
    return (point.character +
        linesUntilPosition
            .map(function (line) { return line.length + 1; })
            .reduce(function (a, b) { return a + b; }, 0));
}
exports.pointToOffset = pointToOffset;
//# sourceMappingURL=getASTNodeAtPosition.js.map