"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var graphql_1 = require("graphql");
var ExecutableDefinitions_1 = require("graphql/validation/rules/ExecutableDefinitions");
function validateWithCustomRules(schema, ast, customRules, isRelayCompatMode) {
    var rules = graphql_1.specifiedRules.filter(function (rule) {
        if (rule === graphql_1.NoUnusedFragmentsRule || rule === ExecutableDefinitions_1.ExecutableDefinitions) {
            return false;
        }
        if (isRelayCompatMode && rule === graphql_1.KnownFragmentNamesRule) {
            return false;
        }
        return true;
    });
    if (customRules) {
        Array.prototype.push.apply(rules, customRules);
    }
    var errors = graphql_1.validate(schema, ast, rules);
    return errors.filter(function (error) {
        if (error.message.indexOf('Unknown directive') !== -1 && error.nodes) {
            var node = error.nodes[0];
            if (node && node.kind === graphql_1.Kind.DIRECTIVE) {
                var name_1 = node.name.value;
                if (name_1 === 'arguments' || name_1 === 'argumentDefinitions') {
                    return false;
                }
            }
        }
        return true;
    });
}
exports.validateWithCustomRules = validateWithCustomRules;
//# sourceMappingURL=validateWithCustomRules.js.map