import { Kind, specifiedRules, validate, NoUnusedFragmentsRule, KnownFragmentNamesRule, } from 'graphql';
import { ExecutableDefinitions } from 'graphql/validation/rules/ExecutableDefinitions';
export function validateWithCustomRules(schema, ast, customRules, isRelayCompatMode) {
    var rules = specifiedRules.filter(function (rule) {
        if (rule === NoUnusedFragmentsRule || rule === ExecutableDefinitions) {
            return false;
        }
        if (isRelayCompatMode && rule === KnownFragmentNamesRule) {
            return false;
        }
        return true;
    });
    if (customRules) {
        Array.prototype.push.apply(rules, customRules);
    }
    var errors = validate(schema, ast, rules);
    return errors.filter(function (error) {
        if (error.message.indexOf('Unknown directive') !== -1 && error.nodes) {
            var node = error.nodes[0];
            if (node && node.kind === Kind.DIRECTIVE) {
                var name_1 = node.name.value;
                if (name_1 === 'arguments' || name_1 === 'argumentDefinitions') {
                    return false;
                }
            }
        }
        return true;
    });
}
//# sourceMappingURL=validateWithCustomRules.js.map