"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultSchemaBuilder = exports.defaultSchemaLoader = void 0;
const graphql_1 = require("graphql");
exports.defaultSchemaLoader = (schemaConfig) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    const { requestOpts, uri, introspectionOptions } = schemaConfig;
    if (!uri) {
        return null;
    }
    const fetchResult = yield fetch(uri, Object.assign({ method: (_a = requestOpts === null || requestOpts === void 0 ? void 0 : requestOpts.method) !== null && _a !== void 0 ? _a : 'post', body: JSON.stringify({
            query: graphql_1.getIntrospectionQuery(introspectionOptions),
            operationName: 'IntrospectionQuery',
        }), credentials: 'omit', headers: (requestOpts === null || requestOpts === void 0 ? void 0 : requestOpts.headers) || {
            'Content-Type': 'application/json',
        } }, requestOpts));
    const introspectionResponse = yield fetchResult.json();
    return introspectionResponse === null || introspectionResponse === void 0 ? void 0 : introspectionResponse.data;
});
function defaultSchemaBuilder(response, buildSchemaOptions) {
    if (!response) {
        throw Error('Empty schema response');
    }
    if ('__schema' in response) {
        return graphql_1.buildClientSchema(response, buildSchemaOptions);
    }
    return graphql_1.buildASTSchema(response, buildSchemaOptions);
}
exports.defaultSchemaBuilder = defaultSchemaBuilder;
//# sourceMappingURL=schemaLoader.js.map