import { parse, GraphQLSchema, ParseOptions, ValidationRule, FragmentDefinitionNode } from 'graphql';
import type { IPosition } from 'graphql-language-service-types';
import { defaultSchemaLoader, SchemaConfig, SchemaResponse, defaultSchemaBuilder } from './schemaLoader';
export declare type GraphQLLanguageConfig = {
    parser?: typeof parse;
    schemaLoader?: typeof defaultSchemaLoader;
    schemaBuilder?: typeof defaultSchemaBuilder;
    schemaString?: string;
    parseOptions?: ParseOptions;
    schemaConfig: SchemaConfig;
    exteralFragmentDefinitions?: FragmentDefinitionNode[] | string;
};
export declare class LanguageService {
    private _parser;
    private _schema;
    private _schemaConfig;
    private _schemaResponse;
    private _schemaLoader;
    private _schemaBuilder;
    private _schemaString;
    private _parseOptions;
    private _exteralFragmentDefinitionNodes;
    private _exteralFragmentDefinitionsString;
    constructor({ parser, schemaLoader, schemaBuilder, schemaConfig, schemaString, parseOptions, exteralFragmentDefinitions, }: GraphQLLanguageConfig);
    get schema(): GraphQLSchema;
    getSchema(): Promise<GraphQLSchema | null>;
    getExternalFragmentDefinitions(): Promise<FragmentDefinitionNode[]>;
    setSchema(schema: string): Promise<void>;
    getSchemaResponse(): Promise<SchemaResponse | null>;
    loadSchemaResponse(): Promise<SchemaResponse | null>;
    loadSchema(): Promise<GraphQLSchema | null>;
    parse(text: string, options?: ParseOptions): Promise<import("graphql").DocumentNode>;
    getCompletion: (_uri: string, documentText: string, position: IPosition) => Promise<import("graphql-language-service-types").CompletionItem[]>;
    getDiagnostics: (_uri: string, documentText: string, customRules?: ValidationRule[] | undefined) => Promise<import("vscode-languageserver-types").Diagnostic[]>;
    getHover: (_uri: string, documentText: string, position: IPosition) => Promise<string | import("vscode-languageserver-types").MarkupContent | {
        language: string;
        value: string;
    } | import("vscode-languageserver-types").MarkedString[]>;
}
//# sourceMappingURL=LanguageService.d.ts.map