var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { parse, visit, } from 'graphql';
import { getAutocompleteSuggestions, getDiagnostics, getHoverInformation, } from 'graphql-language-service-interface';
import { defaultSchemaLoader, defaultSchemaBuilder, } from './schemaLoader';
export class LanguageService {
    constructor({ parser, schemaLoader, schemaBuilder, schemaConfig, schemaString, parseOptions, exteralFragmentDefinitions, }) {
        this._parser = parse;
        this._schema = null;
        this._schemaResponse = null;
        this._schemaLoader = defaultSchemaLoader;
        this._schemaBuilder = defaultSchemaBuilder;
        this._schemaString = null;
        this._parseOptions = undefined;
        this._exteralFragmentDefinitionNodes = null;
        this._exteralFragmentDefinitionsString = null;
        this.getCompletion = (_uri, documentText, position) => __awaiter(this, void 0, void 0, function* () {
            const schema = yield this.getSchema();
            if (!documentText || documentText.length < 1 || !schema) {
                return [];
            }
            return getAutocompleteSuggestions(schema, documentText, position, undefined, yield this.getExternalFragmentDefinitions());
        });
        this.getDiagnostics = (_uri, documentText, customRules) => __awaiter(this, void 0, void 0, function* () {
            const schema = yield this.getSchema();
            if (!documentText || documentText.length < 1 || !schema) {
                return [];
            }
            return getDiagnostics(documentText, schema, customRules);
        });
        this.getHover = (_uri, documentText, position) => __awaiter(this, void 0, void 0, function* () {
            return getHoverInformation((yield this.getSchema()), documentText, position);
        });
        this._schemaConfig = schemaConfig;
        if (parser) {
            this._parser = parser;
        }
        if (schemaLoader) {
            this._schemaLoader = schemaLoader;
        }
        if (schemaBuilder) {
            this._schemaBuilder = schemaBuilder;
        }
        if (schemaString) {
            this._schemaString = schemaString;
        }
        if (parseOptions) {
            this._parseOptions = parseOptions;
        }
        if (exteralFragmentDefinitions) {
            if (Array.isArray(exteralFragmentDefinitions)) {
                this._exteralFragmentDefinitionNodes = exteralFragmentDefinitions;
            }
            else {
                this._exteralFragmentDefinitionsString = exteralFragmentDefinitions;
            }
        }
    }
    get schema() {
        return this._schema;
    }
    getSchema() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.schema) {
                return this.schema;
            }
            return this.loadSchema();
        });
    }
    getExternalFragmentDefinitions() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this._exteralFragmentDefinitionNodes &&
                this._exteralFragmentDefinitionsString) {
                const definitionNodes = [];
                try {
                    visit(yield this._parser(this._exteralFragmentDefinitionsString), {
                        FragmentDefinition(node) {
                            definitionNodes.push(node);
                        },
                    });
                }
                catch (err) {
                    throw Error(`Failed parsing exteralFragmentDefinitions string:\n${this._exteralFragmentDefinitionsString}`);
                }
                this._exteralFragmentDefinitionNodes = definitionNodes;
            }
            return this._exteralFragmentDefinitionNodes;
        });
    }
    setSchema(schema) {
        return __awaiter(this, void 0, void 0, function* () {
            this._schemaString = schema;
            yield this.loadSchema();
        });
    }
    getSchemaResponse() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this._schemaResponse) {
                return this._schemaResponse;
            }
            return this.loadSchemaResponse();
        });
    }
    loadSchemaResponse() {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            if (this._schemaString) {
                return typeof this._schemaString === 'string'
                    ? this.parse(this._schemaString)
                    : this._schemaString;
            }
            if (!((_a = this._schemaConfig) === null || _a === void 0 ? void 0 : _a.uri)) {
                return null;
            }
            this._schemaResponse = (yield this._schemaLoader(this._schemaConfig));
            return this._schemaResponse;
        });
    }
    loadSchema() {
        return __awaiter(this, void 0, void 0, function* () {
            const schemaResponse = yield this.loadSchemaResponse();
            if (schemaResponse) {
                this._schema = this._schemaBuilder(schemaResponse, this._schemaConfig.buildSchemaOptions);
                return this._schema;
            }
            else {
                return null;
            }
        });
    }
    parse(text, options) {
        return __awaiter(this, void 0, void 0, function* () {
            return this._parser(text, options || this._parseOptions);
        });
    }
}
//# sourceMappingURL=LanguageService.js.map