"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.collectVariables = void 0;
const graphql_1 = require("graphql");
function collectVariables(schema, documentAST) {
    const variableToType = Object.create(null);
    documentAST.definitions.forEach(definition => {
        if (definition.kind === 'OperationDefinition') {
            const variableDefinitions = definition.variableDefinitions;
            if (variableDefinitions) {
                variableDefinitions.forEach(({ variable, type }) => {
                    const inputType = graphql_1.typeFromAST(schema, type);
                    if (inputType) {
                        variableToType[variable.name.value] = inputType;
                    }
                    else if (type.kind === graphql_1.Kind.NAMED_TYPE) {
                        if (type.name.value === 'Float') {
                            variableToType[variable.name.value] = graphql_1.GraphQLFloat;
                        }
                    }
                });
            }
        }
    });
    return variableToType;
}
exports.collectVariables = collectVariables;
//# sourceMappingURL=collectVariables.js.map