import { FragmentDefinitionNode, GraphQLDirective, GraphQLSchema } from 'graphql';
import { CompletionItem, AllTypeInfo, IPosition } from '../types';
import { CharacterStream, ContextToken, State, ContextTokenForCodeMirror } from '../parser';
export declare const SuggestionCommand: {
    command: string;
    title: string;
};
export declare type AutocompleteSuggestionOptions = {
    fillLeafsOnComplete?: boolean;
    schema?: GraphQLSchema;
    uri?: string;
    mode?: GraphQLDocumentMode;
};
export declare function getAutocompleteSuggestions(schema: GraphQLSchema, queryText: string, cursor: IPosition, contextToken?: ContextTokenForCodeMirror, fragmentDefs?: FragmentDefinitionNode[] | string, options?: AutocompleteSuggestionOptions): Array<CompletionItem>;
export declare function getVariableCompletions(queryText: string, schema: GraphQLSchema, token: ContextToken): CompletionItem[];
export declare function getFragmentDefinitions(queryText: string): Array<FragmentDefinitionNode>;
export declare function getTokenAtPosition(queryText: string, cursor: IPosition): ContextToken;
declare type callbackFnType = (stream: CharacterStream, state: State, style: string, index: number) => void | 'BREAK';
export declare function runOnlineParser(queryText: string, callback: callbackFnType): ContextToken;
export declare function canUseDirective(state: State['prevState'], directive: GraphQLDirective): boolean;
export declare function getTypeInfo(schema: GraphQLSchema, tokenState: State): AllTypeInfo;
export declare enum GraphQLDocumentMode {
    TYPE_SYSTEM = "TYPE_SYSTEM",
    EXECUTABLE = "EXECUTABLE"
}
export {};
//# sourceMappingURL=getAutocompleteSuggestions.d.ts.map