"use strict";

var __extends = void 0 && (void 0).__extends || function () {
  var _extendStatics = function extendStatics(d, b) {
    _extendStatics = Object.setPrototypeOf || {
      __proto__: []
    } instanceof Array && function (d, b) {
      d.__proto__ = b;
    } || function (d, b) {
      for (var p in b) {
        if (b.hasOwnProperty(p)) d[p] = b[p];
      }
    };

    return _extendStatics(d, b);
  };

  return function (d, b) {
    _extendStatics(d, b);

    function __() {
      this.constructor = d;
    }

    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
}();

var __makeTemplateObject = void 0 && (void 0).__makeTemplateObject || function (cooked, raw) {
  if (Object.defineProperty) {
    Object.defineProperty(cooked, "raw", {
      value: raw
    });
  } else {
    cooked.raw = raw;
  }

  return cooked;
};

Object.defineProperty(exports, "__esModule", {
  value: true
});

var React = require("react");

var graphql_1 = require("graphql");

var EditorWrapper_1 = require("../EditorWrapper");

var styled_1 = require("../../../styled");

var createSDL_1 = require("../util/createSDL");

var SDLEditor =
/** @class */
function (_super) {
  __extends(SDLEditor, _super);

  function SDLEditor(props) {
    var _this = _super.call(this, props) || this;

    _this.handleScroll = function (e) {
      if (e.doc.scrollTop > 0) {
        return _this.setState({
          overflowY: true
        });
      }

      return _this.setState({
        overflowY: false
      });
    };

    _this.setRef = function (ref) {
      _this.node = ref;
    };

    _this.state = {
      overflowY: false
    }; // Keep a cached version of the value, this cache will be updated when the
    // editor is updated, which can later be used to protect the editor from
    // unnecessary updates during the update lifecycle.

    _this.cachedValue = props.value || '';

    if (_this.props.getRef) {
      _this.props.getRef(_this);
    }

    return _this;
  }

  SDLEditor.prototype.componentDidMount = function () {
    // Lazily require to ensure requiring GraphiQL outside of a Browser context
    // does not produce an error.
    var CodeMirror = require('codemirror');

    require('codemirror/addon/fold/brace-fold');

    require('codemirror/addon/comment/comment');

    require('codemirror-graphql/mode');

    var gutters = [];
    gutters.push('CodeMirror-linenumbers');
    this.editor = CodeMirror(this.node, {
      autofocus: false,
      value: createSDL_1.getSDL(this.props.schema, this.props.settings['schema.disableComments']) || '',
      lineNumbers: false,
      showCursorWhenSelecting: false,
      tabSize: 1,
      mode: 'graphql',
      theme: 'graphiql',
      // lineWrapping: true,
      keyMap: 'sublime',
      readOnly: true,
      gutters: gutters
    });
    global.editor = this.editor;
    this.editor.on('scroll', this.handleScroll);
    this.editor.refresh();
  };

  SDLEditor.prototype.componentDidUpdate = function (prevProps) {
    var CodeMirror = require('codemirror');

    var currentSchemaStr = this.props.schema && graphql_1.printSchema(this.props.schema);
    var prevSchemaStr = prevProps.schema && graphql_1.printSchema(prevProps.schema);

    if (currentSchemaStr !== prevSchemaStr) {
      var initialScroll = this.editor.getScrollInfo();
      this.cachedValue = createSDL_1.getSDL(this.props.schema, this.props.settings['schema.disableComments']) || '';
      this.editor.setValue(createSDL_1.getSDL(this.props.schema, this.props.settings['schema.disableComments']));

      if (this.props.isPollingSchema) {
        this.editor.scrollTo(initialScroll.left, initialScroll.top);
      }

      CodeMirror.signal(this.editor, 'change', this.editor);
    }

    if (this.props.width !== prevProps.width) {
      this.editor.refresh();
    }

    if (this.props.settings['schema.disableComments'] !== prevProps.settings['schema.disableComments']) {
      this.editor.refresh();
    }
  };

  SDLEditor.prototype.UNSAFE_componentWillReceiveProps = function (nextProps) {
    if (this.props.sessionId !== nextProps.sessionId) {
      this.editor.scrollTo(0, 0);
    }
  };

  SDLEditor.prototype.componentWillUnmount = function () {
    if (this.editor) {
      this.editor.off('scroll');
      this.editor = null;
    }
  };

  SDLEditor.prototype.render = function () {
    var overflowY = this.state.overflowY;
    return /*#__PURE__*/React.createElement(EditorWrapper_1["default"], null, overflowY && /*#__PURE__*/React.createElement(OverflowShadow, null), /*#__PURE__*/React.createElement(Editor, {
      ref: this.setRef
    }));
  };

  SDLEditor.prototype.getCodeMirror = function () {
    return this.editor;
  };

  SDLEditor.prototype.getClientHeight = function () {
    return this.node && this.node.clientHeight;
  };

  return SDLEditor;
}(React.PureComponent);

exports["default"] = SDLEditor;
var Editor = styled_1.styled.div(templateObject_1 || (templateObject_1 = __makeTemplateObject(["\n  flex: 1;\n  height: auto;\n  overflow-x: hidden;\n  overflow-y: scroll;\n  .CodeMirror {\n    background: ", ";\n    padding-left: 20px;\n  }\n"], ["\n  flex: 1;\n  height: auto;\n  overflow-x: hidden;\n  overflow-y: scroll;\n  .CodeMirror {\n    background: ", ";\n    padding-left: 20px;\n  }\n"])), function (p) {
  return p.theme.mode === 'dark' ? p.theme.editorColours.editorBackground : 'white';
});
var OverflowShadow = styled_1.styled.div(templateObject_2 || (templateObject_2 = __makeTemplateObject(["\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  height: 1px;\n  box-shadow: 0px 1px 3px rgba(17, 17, 17, 0.1);\n  z-index: 1000;\n"], ["\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  height: 1px;\n  box-shadow: 0px 1px 3px rgba(17, 17, 17, 0.1);\n  z-index: 1000;\n"])));
var templateObject_1, templateObject_2;