"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __makeTemplateObject = (this && this.__makeTemplateObject) || function (cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};
Object.defineProperty(exports, "__esModule", { value: true });
var React = require("react");
var styled_1 = require("../styled");
var TopBar_1 = require("./Playground/TopBar/TopBar");
var ConfigEditor_1 = require("./Playground/ConfigEditor");
var react_redux_1 = require("react-redux");
var reselect_1 = require("reselect");
var selectors_1 = require("../state/general/selectors");
var actions_1 = require("../state/general/actions");
var actions_2 = require("../state/sessions/actions");
var reducers_1 = require("../state/workspace/reducers");
var EditorWrapper_1 = require("./Playground/EditorWrapper");
// TODO: Trigger onSave on CMD+S or CTRL+S
var SettingsEditor = /** @class */ (function (_super) {
    __extends(SettingsEditor, _super);
    function SettingsEditor() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.handleKeydown = function (e) {
            if (e.key === 's' && e.metaKey) {
                e.preventDefault();
                _this.props.onSave();
            }
        };
        return _this;
    }
    SettingsEditor.prototype.componentDidMount = function () {
        window.addEventListener('keydown', this.handleKeydown, true);
    };
    SettingsEditor.prototype.render = function () {
        var isConfig = this.props.isConfig;
        return (<EditorWrapper_1.Container>
        <Wrapper>
          <EditorWrapper_1.default>
            <ConfigEditor_1.ConfigEditor value={this.props.value} onEdit={this.props.onChange} onRunQuery={this.props.onSave} isYaml={this.props.isYaml} readOnly={this.props.readOnly}/>
            <PlaygroundVersion>{window.version}</PlaygroundVersion>
          </EditorWrapper_1.default>
          {!this.props.readOnly && (<ButtonWrapper>
              <TopBar_1.Button onClick={this.props.onSave}>
                Save {isConfig ? "Config" : "Settings"}
              </TopBar_1.Button>
            </ButtonWrapper>)}
        </Wrapper>
      </EditorWrapper_1.Container>);
    };
    return SettingsEditor;
}(React.Component));
exports.SettingsEditor = SettingsEditor;
var playgroundSettingsSelector = reselect_1.createStructuredSelector({
    value: reducers_1.getSettingsString,
});
// tslint:disable
var SettingsEditorHOC = /** @class */ (function (_super) {
    __extends(SettingsEditorHOC, _super);
    function SettingsEditorHOC(props) {
        var _this = _super.call(this, props) || this;
        _this.handleChange = function (value) {
            _this.setState({ value: value });
            _this.props.editSettings();
        };
        _this.handleSave = function () {
            _this.props.onChange(_this.state.value);
            _this.props.saveSettings();
        };
        _this.state = { value: props.value };
        return _this;
    }
    SettingsEditorHOC.prototype.UNSAFE_componentWillReceiveProps = function (nextProps) {
        if (nextProps.value !== this.props.value) {
            this.setState({ value: nextProps.value });
        }
    };
    SettingsEditorHOC.prototype.render = function () {
        return (<SettingsEditor value={this.state.value} onChange={this.handleChange} onSave={this.handleSave}/>);
    };
    return SettingsEditorHOC;
}(React.Component));
exports.PlaygroundSettingsEditor = react_redux_1.connect(playgroundSettingsSelector, {
    onChange: actions_1.setSettingsString,
    editSettings: actions_2.editSettings,
    saveSettings: actions_2.saveSettings,
})(SettingsEditorHOC);
var configSelector = reselect_1.createStructuredSelector({
    value: selectors_1.getConfigString,
});
exports.GraphQLConfigEditor = react_redux_1.connect(configSelector, {
    onChange: actions_1.setConfigString,
})(SettingsEditor);
var Wrapper = styled_1.styled.div(templateObject_1 || (templateObject_1 = __makeTemplateObject(["\n  background: ", ";\n  position: relative;\n  display: flex;\n  flex-flow: column;\n  flex: 1 1 0;\n\n  .CodeMirror {\n    background: ", ";\n    .CodeMirror-code {\n      color: rgba(255, 255, 255, 0.7);\n    }\n    .cm-atom {\n      color: rgba(42, 126, 210, 1);\n    }\n  }\n"], ["\n  background: ", ";\n  position: relative;\n  display: flex;\n  flex-flow: column;\n  flex: 1 1 0;\n\n  .CodeMirror {\n    background: ", ";\n    .CodeMirror-code {\n      color: rgba(255, 255, 255, 0.7);\n    }\n    .cm-atom {\n      color: rgba(42, 126, 210, 1);\n    }\n  }\n"])), function (p) { return p.theme.editorColours.resultBackground; }, function (p) { return p.theme.editorColours.resultBackground; });
var ButtonWrapper = styled_1.styled.div(templateObject_2 || (templateObject_2 = __makeTemplateObject(["\n  position: absolute;\n  top: 16px;\n  right: 16px;\n  z-index: 2;\n"], ["\n  position: absolute;\n  top: 16px;\n  right: 16px;\n  z-index: 2;\n"])));
var PlaygroundVersion = styled_1.styled.span(templateObject_3 || (templateObject_3 = __makeTemplateObject(["\n  position: absolute;\n  right: 20px;\n  bottom: 17px;\n  color: ", ";\n  font-weight: 700;\n  margin-right: 14px;\n"], ["\n  position: absolute;\n  right: 20px;\n  bottom: 17px;\n  color: ", ";\n  font-weight: 700;\n  margin-right: 14px;\n"])), function (p) { return p.theme.editorColours.textInactive; });
var templateObject_1, templateObject_2, templateObject_3;
//# sourceMappingURL=SettingsEditor.jsx.map