"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var React = require("react");
var PollingIcon_1 = require("./PollingIcon");
var SchemaPolling = /** @class */ (function (_super) {
    __extends(SchemaPolling, _super);
    function SchemaPolling(props) {
        var _this = _super.call(this, props) || this;
        _this.setWindowVisibility = function () {
            if (document.visibilityState === 'visible') {
                _this.setState({
                    windowVisible: true,
                }, _this.updatePolling);
            }
            if (document.visibilityState === 'hidden') {
                _this.setState({
                    windowVisible: false,
                }, _this.updatePolling);
            }
        };
        _this.updatePolling = function (props) {
            if (props === void 0) { props = _this.props; }
            _this.clearTimer();
            if (_this.state.windowVisible) {
                // timer starts only when introspection not in flight
                _this.timer = setInterval(function () { return props.onReloadSchema(); }, props.interval);
            }
        };
        _this.state = {
            windowVisible: true,
        };
        return _this;
    }
    SchemaPolling.prototype.componentDidMount = function () {
        this.updatePolling();
        document.addEventListener('visibilitychange', this.setWindowVisibility);
    };
    SchemaPolling.prototype.componentWillUnmount = function () {
        this.clearTimer();
        document.removeEventListener('visibilitychange', this.setWindowVisibility);
    };
    SchemaPolling.prototype.UNSAFE_componentWillReceiveProps = function (nextProps) {
        this.updatePolling(nextProps);
    };
    SchemaPolling.prototype.render = function () {
        return <PollingIcon_1.default animate={this.state.windowVisible}/>;
    };
    SchemaPolling.prototype.clearTimer = function () {
        if (this.timer) {
            clearInterval(this.timer);
            this.timer = null;
        }
    };
    return SchemaPolling;
}(React.Component));
exports.default = SchemaPolling;
//# sourceMappingURL=Polling.jsx.map