import { ISettings } from '../types';
export interface Colours {
    green: string;
    darkBlue: string;
    darkBlue50: string;
    darkBlue60: string;
    darkBlue80: string;
    darkBlue30: string;
    darkBlue20: string;
    darkBlue10: string;
    darkerBlue: string;
    darkestBlue: string;
    white80: string;
    white70: string;
    white60: string;
    white30: string;
    white20: string;
    white10: string;
    white: string;
    black02: string;
    black04: string;
    black07: string;
    black10: string;
    black30: string;
    black40: string;
    black50: string;
    paleText: string;
    paleGrey: string;
    red: string;
    blue: string;
    orange: string;
    purple: string;
    lightGrey: string;
    lighterGrey: string;
    text: string;
    textInactive: string;
}
export interface EditorColours {
    property: string;
    comment: string;
    punctuation: string;
    keyword: string;
    def: string;
    qualifier: string;
    attribute: string;
    number: string;
    string: string;
    builtin: string;
    string2: string;
    variable: string;
    meta: string;
    atom: string;
    ws: string;
    selection: string;
    cursorColor: string;
    text: string;
    textInactive: string;
    background: string;
    sidebarTop: string;
    sidebar: string;
    sidebarBottom: string;
    sidebarItemActive: string;
    sidebarItemSide: string;
    sidebarItemSessions: string;
    tab: string;
    tabInactive: string;
    tabText: string;
    navigationBar: string;
    navigationBarText: string;
    editorBackground: string;
    resultBackground: string;
    leftDrawerBackground: string;
    rightDrawerBackground: string;
    drawerText: string;
    drawerTextInactive: string;
    executeButton: string;
    executeButtonBorder: string;
    executeButtonHover: string;
    executeButtonSubscription: string;
    executeButtonSubscriptionHover: string;
    icon: string;
    iconHover: string;
    pollingIcon: string;
    pollingIconShadow: string;
    button: string;
    buttonHover: string;
    buttonText: string;
    buttonWorkspace: string;
    buttonWorkspaceHover: string;
    buttonWorkspaceText: string;
    circle: string;
    subscriptionTimeBoaderTop: string;
    subscriptionTimeText: string;
}
export declare const darkColours: Colours;
export declare const lightColours: Colours;
export declare const darkEditorColours: EditorColours;
export declare const lightEditorColours: EditorColours;
export interface Sizes {
    small6: string;
    small10: string;
    small12: string;
    small16: string;
    medium25: string;
    smallRadius: string;
    fontLight: string;
    fontSemiBold: string;
    fontTiny: string;
    fontSmall: string;
    fontMedium: string;
}
export declare const sizes: Sizes;
export interface Shorthands {
    [x: string]: any;
}
export declare const shorthands: Shorthands;
export interface ThemeInterface {
    mode: 'light' | 'dark';
    colours: Colours;
    sizes: Sizes;
    shorthands: Shorthands;
    editorColours: EditorColours;
    settings: ISettings;
}
export declare const theme: any;
