/// <reference types="react" />
import * as React from 'react';
import { GraphQLEditor } from './Playground/GraphQLEditor';
import { Session } from '../types';
import PlaygroundStorage from './PlaygroundStorage';
import { DocsState } from '../reducers/graphiql-docs';
import { EditorSettings } from './MiddlewareApp';
import { GraphQLConfig } from '../graphqlConfig';
export interface Response {
    resultID: string;
    date: string;
    time: Date;
}
export interface Props {
    endpoint: string;
    subscriptionsEndpoint?: string;
    projectId?: string;
    adminAuthToken?: string;
    onSuccess?: (graphQLParams: any, response: any) => void;
    isEndpoint?: boolean;
    onboardingStep?: string;
    tether?: any;
    nextStep?: () => void;
    isApp?: boolean;
    onChangeEndpoint?: (endpoint: string) => void;
    share: (state: any) => void;
    shareUrl?: string;
    session?: any;
    onChangeSubscriptionsEndpoint?: (endpoint: string) => void;
    getRef?: (ref: Playground) => void;
    graphqlConfig?: any;
    onSaveSettings: () => void;
    onChangeSettings: (settingsString: string) => void;
    onSaveConfig: () => void;
    onChangeConfig: (configString: string) => void;
    onUpdateSessionCount?: () => void;
    settings: EditorSettings;
    settingsString: string;
    config: GraphQLConfig;
    configString: string;
    configIsYaml: boolean;
    canSaveConfig: boolean;
    fixedEndpoints: boolean;
}
export interface State {
    schema: any;
    sessions: Session[];
    selectedSessionIndex: number;
    schemaCache: any;
    historyOpen: boolean;
    history: Session[];
    adminAuthToken: string | null;
    response?: Response;
    selectUserSessionId?: string;
    codeGenerationPopupOpen: boolean;
    disableQueryHeader: boolean;
    autoReloadSchema: boolean;
    useVim: boolean;
    userModelName: string;
    shareAllTabs: boolean;
    shareHttpHeaders: boolean;
    shareHistory: boolean;
    changed: boolean;
    tracingSupported: boolean;
}
export interface CursorPosition {
    line: number;
    ch: number;
}
export { GraphQLEditor };
export declare class Playground extends React.PureComponent<Props & DocsState, State> {
    storage: PlaygroundStorage;
    wsConnections: {
        [sessionId: string]: any;
    };
    observers: {
        [sessionId: string]: any;
    };
    graphiqlComponents: any[];
    private initialIndex;
    private schemaFetcher;
    private updateQueryTypes;
    private handleQueryChange;
    constructor(props: Props & DocsState);
    getStorageKey(props?: Props): string;
    componentWillMount(): void;
    componentDidMount(): void;
    componentDidUpdate(prevProps: Props, prevState: State): void;
    componentWillUnmount(): void;
    setWS: (session: Session) => void;
    initWebsockets(): void;
    setCursor(position: CursorPosition): void;
    render(): JSX.Element;
    renderHistoryPopup(): JSX.Element;
    renderCodeGenerationPopup(): JSX.Element;
    setRef: (index: number, ref: any) => void;
    toggleSchemaReload: () => void;
    handleChangeSettings: (settings: string) => void;
    handleSaveSettings: () => void;
    handleChangeConfig: (config: string) => void;
    handleSaveConfig: () => void;
    handleFileChange: (file: any) => void;
    handleSaveFile: (file: any) => void;
    openSettingsTab: () => void;
    openConfigTab: () => void;
    newSession: (name?: string | undefined) => void;
    newFileTab: (fileName: string, filePath: string, file: string) => void;
    closeTab: () => boolean;
    nextTab: () => void;
    prevTab: () => void;
    handleNewSession: (newIndexZero?: boolean) => void;
    setValueInSession(sessionId: string, key: string, value: any, cb?: () => void): void;
    private handleClickCodeGeneration;
    private handleCloseCodeGeneration;
    private resetSubscriptions();
    private resetSubscription(session);
    private getUrlSession(sessions);
    private handleCreateSession;
    private handleItemStarToggled;
    private handleCloseSession;
    private handleOpenHistory;
    private handleCloseHistory;
    private handleSelectSession;
    private handleChangeEndpoint;
    private initSessions;
    private saveSessions;
    private saveHistory;
    private handleNewSessionWithoutNewIndexZero;
    private createSession;
    private createSessionFromQuery;
    private handleChangeHeaders;
    private handleVariableChange;
    private handleOperationNameChange;
    private setValueInHistory(sessionId, key, value);
    private isGraphcoolUrl(endpoint);
    private getEndpoint();
    readonly httpApiPrefix: string;
    private getWSEndpoint();
    private addToHistory(session);
    private historyIncludes(session);
    private cancelSubscription;
    private fetcher;
    private parseHeaders(headers);
    private isSharingAuthorization;
    private toggleShareAllTabs;
    private toggleShareHTTPHeaders;
    private toggleShareHistory;
    private share;
}
declare const _default: any;
export default _default;
