"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var React = require("react");
var graphql_1 = require("graphql");
function Argument(_a) {
    var arg = _a.arg, showDefaultValue = _a.showDefaultValue;
    return (<div className="arg">
      <style jsx={true}>{"\n        .arg {\n          @p: .ml16;\n        }\n      "}</style>
      <span className="arg-name">
        {arg.name}
      </span>
      {': '}
      <span className="type-name">
        {renderType(arg.type)}
      </span>
      {arg.defaultValue !== undefined &&
        showDefaultValue !== false &&
        <span>
          {' = '}
          <span className="arg-default-value">
            {graphql_1.print(graphql_1.astFromValue(arg.defaultValue, arg.type))}
          </span>
        </span>}
    </div>);
}
exports.default = Argument;
function renderType(type) {
    if (type instanceof graphql_1.GraphQLNonNull) {
        return (<span>
        {renderType(type.ofType)}
        {'!'}
      </span>);
    }
    if (type instanceof graphql_1.GraphQLList) {
        return (<span>
        {'['}
        {renderType(type.ofType)}
        {']'}
      </span>);
    }
    return (<span>
      {type.name}
    </span>);
}
//# sourceMappingURL=ArgumentInline.jsx.map