"use strict";

var _style = require("styled-jsx/style");

var _style2 = _interopRequireDefault(_style);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

Object.defineProperty(exports, "__esModule", { value: true });
var React = require("react");
var cx = require("classnames");
var graphcool_styles_1 = require("graphcool-styles");
var Theme_1 = require("../Theme");
var Tab_1 = require("./Tab");
var white20 = '#4a555f';
var darkBlue20 = '#c2c8cb';
exports.TabBar = Theme_1.withTheme(function (_a) {
  var sessions = _a.sessions,
      selectedSessionIndex = _a.selectedSessionIndex,
      onNewSession = _a.onNewSession,
      onSelectSession = _a.onSelectSession,
      onCloseSession = _a.onCloseSession,
      localTheme = _a.localTheme,
      isApp = _a.isApp;
  return React.createElement(
    "div",
    { className: cx('tabbar', localTheme), "data-jsx": 3449270228
    },
    React.createElement(_style2.default, {
      styleId: 3449270228,
      css: ".tab[data-jsx=\"3449270228\"] {height: 43px;padding: 10px;padding-top: 9px;border-bottom: 2px solid #172a3a;}.light[data-jsx=\"3449270228\"] .tab[data-jsx=\"3449270228\"] {background-color: #e7eaec;border-bottom: 2px solid #eeeff0;}.light[data-jsx=\"3449270228\"] .tab[data-jsx=\"3449270228\"].active[data-jsx=\"3449270228\"] {background-color: #eeeff0;}.tabbar[data-jsx=\"3449270228\"] {height: 57px;background-color: rgba(9, 20, 28, 1);-webkit-app-region: drag;path[data-jsx=\"3449270228\"] {stroke: white;}}.tabbar.light[data-jsx=\"3449270228\"] {background-color: #dbdee0;}.tabs[data-jsx=\"3449270228\"] {margin-right: 60px;}.tabs.isApp[data-jsx=\"3449270228\"] {padding-left: 52px;}.red-dot[data-jsx=\"3449270228\"] {width: 7px;height: 7px;}.query-type[data-jsx=\"3449270228\"] {height: 21px;width: 21px;margin-right: 2px;}.close[data-jsx=\"3449270228\"] {top: 1px}.plus[data-jsx=\"3449270228\"] {width: 43px;}.history[data-jsx=\"3449270228\"] {top: 15px;right: 56px;}.change-theme[data-jsx=\"3449270228\"] {top: 200px;right: 200px;}.border-bottom[data-jsx=\"3449270228\"] {height: 8px;background-color: #eeeff0;width: 100%;top: -2px;position: relative;}.light.tab[data-jsx=\"3449270228\"]:hover {background-color: #eeeff0;}.history[data-jsx=\"3449270228\"]:hover .icon svg,.history.open[data-jsx=\"3449270228\"] .icon svg {stroke: rgba(255, 255, 255, .6);}.history.light[data-jsx=\"3449270228\"]:hover .icon svg,.history.light.open[data-jsx=\"3449270228\"] .icon svg {stroke: rgba(23, 42, 58, .6);}.flex,\n.tab[data-jsx=\"3449270228\"],\n.tabs[data-jsx=\"3449270228\"],\n.icons[data-jsx=\"3449270228\"],\n.query-type[data-jsx=\"3449270228\"],\n.plus[data-jsx=\"3449270228\"] {display: -ms-flexbox;display: flex;}.itemsCenter,\n.tab[data-jsx=\"3449270228\"],\n.tabs[data-jsx=\"3449270228\"],\n.icons[data-jsx=\"3449270228\"],\n.query-type[data-jsx=\"3449270228\"],\n.plus[data-jsx=\"3449270228\"] {-webkit-box-align: center;-ms-flex-align: center;-ms-grid-row-align: center;align-items: center;}.bgDarkerBlue,\n.tab[data-jsx=\"3449270228\"] {background-color: #0f202e;}.br2,\n.tab[data-jsx=\"3449270228\"],\n.query-type[data-jsx=\"3449270228\"] {border-radius: 2px;}.brTop,\n.tab[data-jsx=\"3449270228\"] {border-bottom-right-radius: 0;}.brRight,\n.brTop,\n.tab[data-jsx=\"3449270228\"] {border-bottom-left-radius: 0;}.ml10,\n.tab[data-jsx=\"3449270228\"],\n.close[data-jsx=\"3449270228\"] {margin-left: 10px;}.bbox,\n.tab[data-jsx=\"3449270228\"] {box-sizing: border-box;}.pointer:hover,\n.tab[data-jsx=\"3449270228\"]:hover,\n.history[data-jsx=\"3449270228\"]:hover,\n.change-theme[data-jsx=\"3449270228\"]:hover {cursor: pointer;}.bgDarkBlue,\n.tab[data-jsx=\"3449270228\"].active[data-jsx=\"3449270228\"],\n.tab[data-jsx=\"3449270228\"]:hover {background-color: #172a3a;}.white,\n.tabbar[data-jsx=\"3449270228\"],\n.light[data-jsx=\"3449270228\"] .query-type[data-jsx=\"3449270228\"] {color: #fff;}.z4,\n.tabbar[data-jsx=\"3449270228\"] {z-index: 4;}.darkBlue50,\n.tabbar.light[data-jsx=\"3449270228\"] {color: rgba(23,42,58,.5);}.mt16,\n.tabs[data-jsx=\"3449270228\"] {margin-top: 16px;}.ml0,\n.tabs[data-jsx=\"3449270228\"] {margin-left: 0;}.flex,\n.tab[data-jsx=\"3449270228\"],\n.tabs[data-jsx=\"3449270228\"],\n.icons[data-jsx=\"3449270228\"],\n.query-type[data-jsx=\"3449270228\"],\n.plus[data-jsx=\"3449270228\"] {display: -ms-flexbox;display: flex;}.itemsCenter,\n.tab[data-jsx=\"3449270228\"],\n.tabs[data-jsx=\"3449270228\"],\n.icons[data-jsx=\"3449270228\"],\n.query-type[data-jsx=\"3449270228\"],\n.plus[data-jsx=\"3449270228\"] {-webkit-box-align: center;-ms-flex-align: center;-ms-grid-row-align: center;align-items: center;}.z0,\n.tabs[data-jsx=\"3449270228\"] {z-index: 0;}.overflowAuto,\n.tabs[data-jsx=\"3449270228\"] {overflow: auto;}.flex,\n.tab[data-jsx=\"3449270228\"],\n.tabs[data-jsx=\"3449270228\"],\n.icons[data-jsx=\"3449270228\"],\n.query-type[data-jsx=\"3449270228\"],\n.plus[data-jsx=\"3449270228\"] {display: -ms-flexbox;display: flex;}.itemsCenter,\n.tab[data-jsx=\"3449270228\"],\n.tabs[data-jsx=\"3449270228\"],\n.icons[data-jsx=\"3449270228\"],\n.query-type[data-jsx=\"3449270228\"],\n.plus[data-jsx=\"3449270228\"] {-webkit-box-align: center;-ms-flex-align: center;-ms-grid-row-align: center;align-items: center;}.o50,\n.icons[data-jsx=\"3449270228\"],\n.operation-name[data-jsx=\"3449270228\"],\n.close[data-jsx=\"3449270228\"] {opacity: .5;}.o100,\n.icons[data-jsx=\"3449270228\"].active[data-jsx=\"3449270228\"],\n.operation-name[data-jsx=\"3449270228\"].active[data-jsx=\"3449270228\"],\n.close[data-jsx=\"3449270228\"].active[data-jsx=\"3449270228\"] {opacity: 1;}.br100,\n.red-dot[data-jsx=\"3449270228\"] {border-radius: 100%;}.bgrRed,\n.red-dot[data-jsx=\"3449270228\"] {background-color: #f25c54;}.mr10,\n.red-dot[data-jsx=\"3449270228\"],\n.viewer[data-jsx=\"3449270228\"] {margin-right: 10px;}.br2,\n.tab[data-jsx=\"3449270228\"],\n.query-type[data-jsx=\"3449270228\"] {border-radius: 2px;}.flex,\n.tab[data-jsx=\"3449270228\"],\n.tabs[data-jsx=\"3449270228\"],\n.icons[data-jsx=\"3449270228\"],\n.query-type[data-jsx=\"3449270228\"],\n.plus[data-jsx=\"3449270228\"] {display: -ms-flexbox;display: flex;}.itemsCenter,\n.tab[data-jsx=\"3449270228\"],\n.tabs[data-jsx=\"3449270228\"],\n.icons[data-jsx=\"3449270228\"],\n.query-type[data-jsx=\"3449270228\"],\n.plus[data-jsx=\"3449270228\"] {-webkit-box-align: center;-ms-flex-align: center;-ms-grid-row-align: center;align-items: center;}.justifyCenter,\n.query-type[data-jsx=\"3449270228\"],\n.plus[data-jsx=\"3449270228\"] {-ms-flex-pack: center;justify-content: center;}.mr4,\n.query-type[data-jsx=\"3449270228\"] {margin-right: 4px;}.fw7,\n.query-type[data-jsx=\"3449270228\"] {font-weight: 700;}.f12,\n.query-type[data-jsx=\"3449270228\"] {font-size: 12px;}.white,\n.tabbar[data-jsx=\"3449270228\"],\n.light[data-jsx=\"3449270228\"] .query-type[data-jsx=\"3449270228\"] {color: #fff;}.bgPurple,\n.subscription[data-jsx=\"3449270228\"] {background-color: #a4036f;}.bgBlue,\n.query[data-jsx=\"3449270228\"] {background-color: #2a7ed2;}.bgLightOrange,\n.mutation[data-jsx=\"3449270228\"] {background-color: #f18f01;}.mr10,\n.red-dot[data-jsx=\"3449270228\"],\n.viewer[data-jsx=\"3449270228\"] {margin-right: 10px;}.o50,\n.icons[data-jsx=\"3449270228\"],\n.operation-name[data-jsx=\"3449270228\"],\n.close[data-jsx=\"3449270228\"] {opacity: .5;}.o100,\n.icons[data-jsx=\"3449270228\"].active[data-jsx=\"3449270228\"],\n.operation-name[data-jsx=\"3449270228\"].active[data-jsx=\"3449270228\"],\n.close[data-jsx=\"3449270228\"].active[data-jsx=\"3449270228\"] {opacity: 1;}.ml10,\n.tab[data-jsx=\"3449270228\"],\n.close[data-jsx=\"3449270228\"] {margin-left: 10px;}.o50,\n.icons[data-jsx=\"3449270228\"],\n.operation-name[data-jsx=\"3449270228\"],\n.close[data-jsx=\"3449270228\"] {opacity: .5;}.relative,\n.close[data-jsx=\"3449270228\"] {position: relative;}.o100,\n.icons[data-jsx=\"3449270228\"].active[data-jsx=\"3449270228\"],\n.operation-name[data-jsx=\"3449270228\"].active[data-jsx=\"3449270228\"],\n.close[data-jsx=\"3449270228\"].active[data-jsx=\"3449270228\"] {opacity: 1;}.flex,\n.tab[data-jsx=\"3449270228\"],\n.tabs[data-jsx=\"3449270228\"],\n.icons[data-jsx=\"3449270228\"],\n.query-type[data-jsx=\"3449270228\"],\n.plus[data-jsx=\"3449270228\"] {display: -ms-flexbox;display: flex;}.justifyCenter,\n.query-type[data-jsx=\"3449270228\"],\n.plus[data-jsx=\"3449270228\"] {-ms-flex-pack: center;justify-content: center;}.itemsCenter,\n.tab[data-jsx=\"3449270228\"],\n.tabs[data-jsx=\"3449270228\"],\n.icons[data-jsx=\"3449270228\"],\n.query-type[data-jsx=\"3449270228\"],\n.plus[data-jsx=\"3449270228\"] {-webkit-box-align: center;-ms-flex-align: center;-ms-grid-row-align: center;align-items: center;}.pointer:hover,\n.tab[data-jsx=\"3449270228\"]:hover,\n.history[data-jsx=\"3449270228\"]:hover,\n.change-theme[data-jsx=\"3449270228\"]:hover {cursor: pointer;}.absolute,\n.history[data-jsx=\"3449270228\"],\n.change-theme[data-jsx=\"3449270228\"] {position: absolute;}.absolute,\n.history[data-jsx=\"3449270228\"],\n.change-theme[data-jsx=\"3449270228\"] {position: absolute;}.pointer:hover,\n.tab[data-jsx=\"3449270228\"]:hover,\n.history[data-jsx=\"3449270228\"]:hover,\n.change-theme[data-jsx=\"3449270228\"]:hover {cursor: pointer;}.bgDarkBlue,\n.tab[data-jsx=\"3449270228\"].active[data-jsx=\"3449270228\"],\n.tab[data-jsx=\"3449270228\"]:hover {background-color: #172a3a;}"
    }),
    React.createElement(
      "div",
      { className: cx('tabs', { isApp: isApp }), "data-jsx": 3449270228
      },
      sessions.map(function (session, index) {
        return React.createElement(Tab_1.default, { key: session.id, session: session, index: index, onSelectSession: onSelectSession, selectedSessionIndex: selectedSessionIndex, onCloseSession: onCloseSession, localTheme: localTheme });
      }),
      React.createElement(
        "div",
        { className: "tab plus", onClick: onNewSession, "data-jsx": 3449270228
        },
        React.createElement(graphcool_styles_1.Icon, { src: require('graphcool-styles/icons/stroke/add.svg'), color: localTheme === 'dark' ? white20 : darkBlue20, width: 34, height: 34, stroke: true, strokeWidth: 4 })
      )
    )
  );
});
//# sourceMappingURL=TabBar.jsx.map