"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var React = require("react");
var cx = require("classnames");
var graphcool_styles_1 = require("graphcool-styles");
var Theme_1 = require("../Theme");
var Tab_1 = require("./Tab");
var white20 = '#4a555f';
var darkBlue20 = '#c2c8cb';
exports.TabBar = Theme_1.withTheme(function (_a) {
    var sessions = _a.sessions, selectedSessionIndex = _a.selectedSessionIndex, onNewSession = _a.onNewSession, onSelectSession = _a.onSelectSession, onCloseSession = _a.onCloseSession, localTheme = _a.localTheme, isApp = _a.isApp;
    return (<div className={cx('tabbar', localTheme)}>
        <style jsx={true}>{"\n          .tab {\n            @p: .flex,\n              .itemsCenter,\n              .bgDarkerBlue,\n              .br2,\n              .brTop,\n              .ml10,\n              .bbox,\n              .pointer;\n            height: 43px;\n            padding: 10px;\n            padding-top: 9px;\n            &.active {\n              @p: .bgDarkBlue;\n            }\n            border-bottom: 2px solid #172a3a;\n          }\n          .light .tab {\n            background-color: #e7eaec;\n            &.active {\n              background-color: #eeeff0;\n            }\n            border-bottom: 2px solid #eeeff0;\n          }\n          .tabbar {\n            @p: .white, .z4;\n            height: 57px;\n            background-color: $darkBlueGray;\n            -webkit-app-region: drag;\n\n            path {\n              stroke: white;\n            }\n          }\n          .tabbar.light {\n            @p: .darkBlue50;\n            background-color: #dbdee0;\n          }\n\n          .tabs {\n            @p: .mt16, .ml0, .flex, .itemsCenter, .z0, .overflowAuto;\n            margin-right: 60px;\n          }\n\n          .tabs.isApp {\n            padding-left: 52px;\n          }\n\n          .icons {\n            @p: .flex, .itemsCenter, .o50;\n            &.active {\n              @p: .o100;\n            }\n          }\n\n          .red-dot {\n            @p: .br100, .bgrRed, .mr10;\n            width: 7px;\n            height: 7px;\n          }\n\n          .query-type {\n            @p: .br2, .flex, .itemsCenter, .justifyCenter, .mr4, .fw7, .f12;\n            height: 21px;\n            width: 21px;\n            margin-right: 2px;\n          }\n\n          .light .query-type {\n            @p: .white;\n          }\n\n          .subscription {\n            @p: .bgPurple;\n          }\n\n          .query {\n            @p: .bgBlue;\n          }\n\n          .mutation {\n            @p: .bgLightOrange;\n          }\n\n          .viewer {\n            @p: .mr10;\n          }\n\n          .operation-name {\n            @p: .o50;\n            &.active {\n              @p: .o100;\n            }\n          }\n\n          .close {\n            @p: .ml10, .o50, .relative;\n            top: 1px;\n            &.active {\n              @p: .o100;\n            }\n          }\n\n          .plus {\n            @p: .flex, .justifyCenter, .itemsCenter;\n            width: 43px;\n          }\n\n          .history {\n            @p: .pointer, .absolute;\n            top: 15px;\n            right: 56px;\n          }\n\n          .change-theme {\n            @p: .absolute, .pointer;\n            top: 200px;\n            right: 200px;\n          }\n          .border-bottom {\n            height: 8px;\n            background-color: #eeeff0;\n            width: 100%;\n            top: -2px;\n            position: relative;\n          }\n          .tab:hover {\n            @p: .bgDarkBlue;\n          }\n          .light.tab:hover {\n            background-color: #eeeff0;\n          }\n          .history:hover :global(.icon) :global(svg),\n          .history.open :global(.icon) :global(svg) {\n            stroke: $white60;\n          }\n          .history.light:hover :global(.icon) :global(svg),\n          .history.light.open :global(.icon) :global(svg) {\n            stroke: $darkBlue60;\n          }\n        "}</style>
        <div className={cx('tabs', { isApp: isApp })}>
          {sessions.map(function (session, index) { return (<Tab_1.default key={session.id} session={session} index={index} onSelectSession={onSelectSession} selectedSessionIndex={selectedSessionIndex} onCloseSession={onCloseSession} localTheme={localTheme}/>); })}
          <div className="tab plus" onClick={onNewSession}>
            <graphcool_styles_1.Icon src={require('graphcool-styles/icons/stroke/add.svg')} color={localTheme === 'dark' ? white20 : darkBlue20} width={34} height={34} stroke={true} strokeWidth={4}/>
          </div>
        </div>
      </div>);
});
//# sourceMappingURL=TabBar.jsx.map