import { DocumentNode, GraphQLSchema } from 'graphql';
export declare class Source {
    document: DocumentNode;
    schema?: GraphQLSchema;
    location?: string;
    constructor({ document, location, schema }: {
        document: DocumentNode;
        location?: string;
        schema?: GraphQLSchema;
    });
}
export declare type WithList<T> = T | T[];
export declare type ElementOf<TList> = TList extends Array<infer TElement> ? TElement : never;
export declare type SchemaPointer = WithList<string>;
export declare type SchemaPointerSingle = ElementOf<SchemaPointer>;
export declare type DocumentGlobPathPointer = string;
export declare type DocumentPointer = WithList<DocumentGlobPathPointer>;
export declare type DocumentPointerSingle = ElementOf<DocumentPointer>;
export interface Loader<TPointer = string, TOptions = any> {
    loaderId(): string;
    canLoad(pointer: TPointer, options?: TOptions): Promise<boolean>;
    load(pointer: TPointer, options?: TOptions): Promise<Source | null>;
}
export declare type SchemaLoader<TOptions = any> = Loader<SchemaPointerSingle, TOptions>;
export declare type DocumentLoader<TOptions = any> = Loader<DocumentPointerSingle, TOptions>;
export declare type UniversalLoader<TOptions = any> = Loader<SchemaPointerSingle | DocumentPointerSingle, TOptions>;
