import { GraphQLSchema, GraphQLError, ValidationContext, ASTVisitor } from 'graphql';
import { Source } from './loaders';
export declare type ValidationRule = (context: ValidationContext) => ASTVisitor;
export interface LoadDocumentError {
    readonly filePath: string;
    readonly errors: ReadonlyArray<GraphQLError>;
}
export declare const validateGraphQlDocuments: (schema: GraphQLSchema, documentFiles: Source[], effectiveRules?: ValidationRule[]) => Promise<readonly LoadDocumentError[]>;
export declare function checkValidationErrors(loadDocumentErrors: ReadonlyArray<LoadDocumentError>): void | never;
