'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

const graphql = require('graphql');
const simplegit = _interopDefault(require('simple-git/promise'));

// git:branch:path/to/file
function extractData(pointer) {
    const parts = pointer.replace(/^git\:/i, '').split(':');
    if (!parts || parts.length !== 2) {
        throw new Error('Schema pointer should match "git:branchName:path/to/file"');
    }
    return {
        ref: parts[0],
        path: parts[1],
    };
}
class GitLoader {
    loaderId() {
        return 'git-loader';
    }
    async canLoad(pointer) {
        return typeof pointer === 'string' && pointer.toLowerCase().startsWith('git:');
    }
    async load(pointer) {
        const { ref, path } = extractData(pointer);
        const git = simplegit();
        let schemaString;
        try {
            schemaString = await git.show([`${ref}:${path}`]);
        }
        catch (error) {
            throw new Error('Unable to load schema from git: ' + error);
        }
        let document;
        if (/\.(gql|graphql)s?$/i.test(path)) {
            document = graphql.parse(schemaString);
        }
        if (/\.json$/i.test(path)) {
            document = graphql.parse(graphql.printSchema(graphql.buildClientSchema(JSON.parse(schemaString))));
        }
        if (!document) {
            throw new Error('Unable to build schema from git');
        }
        return {
            location: pointer,
            document,
        };
    }
}

exports.GitLoader = GitLoader;
