import { GraphQLSchema, DocumentNode } from 'graphql';
import { IResolvers, SchemaDirectiveVisitor, IResolverValidationOptions, ILogger } from '@kamilkisiela/graphql-tools';
import { Config } from './typedefs-mergers/merge-typedefs';
import { ResolversComposerMapping } from '@graphql-toolkit/common';
export interface MergeSchemasConfig<Resolvers extends IResolvers = IResolvers> extends Config {
    schemas: GraphQLSchema[];
    typeDefs?: (DocumentNode | string)[] | DocumentNode | string;
    resolvers?: Resolvers | Resolvers[];
    resolversComposition?: ResolversComposerMapping<Resolvers>;
    schemaDirectives?: {
        [directiveName: string]: typeof SchemaDirectiveVisitor;
    };
    resolverValidationOptions?: IResolverValidationOptions;
    logger?: ILogger;
}
export declare function mergeSchemas({ schemas, typeDefs, resolvers, resolversComposition, schemaDirectives, resolverValidationOptions, logger, ...config }: MergeSchemasConfig): GraphQLSchema;
export declare function mergeSchemasAsync({ schemas, typeDefs, resolvers, resolversComposition, schemaDirectives, resolverValidationOptions, logger, ...config }: MergeSchemasConfig): Promise<GraphQLSchema>;
