import * as React from 'react';
import * as PropTypes from 'prop-types';
import { Store } from 'redux';
import './Voyager.css';
import './viewport.css';
import { SVGRender } from './../graph/';
import { Viewport } from './../graph/';
import { StateInterface } from '../reducers';
import { WorkerCallback } from '../utils/types';
declare type IntrospectionProvider = (query: string) => Promise<any>;
export interface VoyagerDisplayOptions {
    rootType?: string;
    skipRelay?: boolean;
    showLeafFields?: boolean;
    sortByAlphabet?: boolean;
    hideRoot?: boolean;
}
export interface VoyagerProps {
    _schemaPresets?: any;
    introspection: IntrospectionProvider | Object | boolean;
    displayOptions?: VoyagerDisplayOptions;
    hideDocs?: boolean;
    hideSettings?: boolean;
    workerURI?: string;
    loadWorker?: WorkerCallback;
    children?: React.ReactNode;
}
export default class Voyager extends React.Component<VoyagerProps> {
    static propTypes: {
        introspection: PropTypes.Validator<boolean | object>;
        _schemaPresets: PropTypes.Requireable<object>;
        displayOptions: PropTypes.Requireable<PropTypes.InferProps<{
            rootType: PropTypes.Requireable<string>;
            skipRelay: PropTypes.Requireable<boolean>;
            sortByAlphabet: PropTypes.Requireable<boolean>;
            hideRoot: PropTypes.Requireable<boolean>;
            showLeafFields: PropTypes.Requireable<boolean>;
        }>>;
        hideDocs: PropTypes.Requireable<boolean>;
        hideSettings: PropTypes.Requireable<boolean>;
        workerURI: PropTypes.Requireable<string>;
        loadWorker: PropTypes.Requireable<(...args: any[]) => any>;
    };
    viewport: Viewport;
    renderer: SVGRender;
    store: Store<StateInterface>;
    constructor(props: any);
    componentDidMount(): void;
    componentWillUnmount(): void;
    updateIntrospection(): void;
    componentDidUpdate(prevProps: VoyagerProps): void;
    render(): JSX.Element;
    static PanelHeader: (props: any) => any;
}
export {};
