export declare type DisplayOptions = {
    rootTypeId?: string;
    skipRelay: boolean;
    sortByAlphabet: boolean;
    showLeafFields: boolean;
    hideRoot: boolean;
};
export declare type StateInterface = {
    schema: any;
    displayOptions: DisplayOptions;
    selected: {
        previousTypesIds: string[];
        currentNodeId: string | null;
        currentEdgeId: string | null;
        scalar: string | null;
    };
    graphView: {
        svg: string;
        focusedId: string | null;
    };
    errorMessage: string | null;
};
export declare function rootReducer(previousState: StateInterface, action: any): {
    schema: any;
    displayOptions: any;
    graphView: {
        svg: string;
        focusedId: string;
    };
    selected: {
        previousTypesIds: string[];
        currentNodeId: string;
        currentEdgeId: string;
        scalar: string;
    };
    errorMessage: string;
} | {
    graphView: {
        svg: any;
        focusedId: string;
    };
    schema: any;
    displayOptions: DisplayOptions;
    selected: {
        previousTypesIds: string[];
        currentNodeId: string;
        currentEdgeId: string;
        scalar: string;
    };
    errorMessage: string;
} | {
    selected: {
        previousTypesIds: string[];
        currentNodeId: any;
        currentEdgeId: any;
        scalar: any;
    };
    schema: any;
    displayOptions: DisplayOptions;
    graphView: {
        svg: string;
        focusedId: string;
    };
    errorMessage: string;
} | {
    selected: {
        previousTypesIds: string[];
        currentNodeId: string;
        currentEdgeId: any;
        scalar: any;
    };
    schema: any;
    displayOptions: DisplayOptions;
    graphView: {
        svg: string;
        focusedId: string;
    };
    errorMessage: string;
} | {
    graphView: {
        focusedId: any;
        svg: string;
    };
    schema: any;
    displayOptions: DisplayOptions;
    selected: {
        previousTypesIds: string[];
        currentNodeId: string;
        currentEdgeId: string;
        scalar: string;
    };
    errorMessage: string;
} | {
    errorMessage: any;
    schema: any;
    displayOptions: DisplayOptions;
    selected: {
        previousTypesIds: string[];
        currentNodeId: string;
        currentEdgeId: string;
        scalar: string;
    };
    graphView: {
        svg: string;
        focusedId: string;
    };
} | {
    selected: {
        typeinfo: any;
        previousTypesIds: string[];
        currentNodeId: string;
        currentEdgeId: string;
        scalar: string;
    };
    schema: any;
    displayOptions: DisplayOptions;
    graphView: {
        svg: string;
        focusedId: string;
    };
    errorMessage: string;
};
