"use strict";
exports.__esModule = true;
var version = require('../package.json').version;
function renderVoyagerPage(options) {
    var endpointUrl = options.endpointUrl, displayOptions = options.displayOptions;
    var headersJS = options.headersJS ? options.headersJS : '{}';
    return "\n<!DOCTYPE html>\n<html>\n<head>\n  <meta charset=utf-8 />\n  <meta name=\"viewport\" content=\"user-scalable=no, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0\">\n  <title>GraphQL Voyager</title>\n  <style>\n    body {\n      padding: 0;\n      margin: 0;\n      width: 100%;\n      height: 100vh;\n      overflow: hidden;\n    }\n    #voyager {\n      height: 100vh;\n    }\n  </style>\n  <link rel=\"stylesheet\"\n    href=\"https://cdn.jsdelivr.net/npm/graphql-voyager@".concat(version, "/dist/voyager.css\"\n  />\n  <script src=\"https://cdn.jsdelivr.net/npm/graphql-voyager@").concat(version, "/dist/voyager.standalone.js\"></script>\n</head>\n<body>\n  <main id=\"voyager\">\n    <h1 style=\"text-align: center; color: #5d7e86;\"> Loading... </h1>\n  </main>\n  <script type=\"module\">\n    window.addEventListener('load', function(event) {\n      const response = fetch('").concat(endpointUrl, "', {\n        method: 'post',\n        headers: Object.assign({}, {\n          'Accept': 'application/json',\n          'Content-Type': 'application/json',\n        }, ").concat(headersJS, "),\n        body: JSON.stringify({\n          query: GraphQLVoyager.voyagerIntrospectionQuery,\n        }),\n        credentials: 'include',\n      });\n      const introspection = await response.json();\n\n      GraphQLVoyager.init(document.getElementById('voyager'), {\n        introspection,\n        displayOptions: ").concat(JSON.stringify(displayOptions), ",\n      });\n    })\n  </script>\n</body>\n</html>\n");
}
exports["default"] = renderVoyagerPage;
