import { Component } from 'react';
import { TypeGraph, Viewport } from './../graph/';
import { VoyagerDisplayOptions } from './Voyager';
interface GraphViewportProps {
    typeGraph: TypeGraph | null;
    displayOptions: VoyagerDisplayOptions;
    selectedTypeID: string | null;
    selectedEdgeID: string | null;
    onSelectNode: (id: string | null) => void;
    onSelectEdge: (id: string) => void;
}
interface GraphViewportState {
    typeGraph: TypeGraph | null;
    displayOptions: VoyagerDisplayOptions | null;
    svgViewport: Viewport | null;
}
export default class GraphViewport extends Component<GraphViewportProps, GraphViewportState> {
    state: GraphViewportState;
    _currentTypeGraph: TypeGraph | null;
    _currentDisplayOptions: VoyagerDisplayOptions | null;
    static getDerivedStateFromProps(props: GraphViewportProps, state: GraphViewportState): GraphViewportState | null;
    componentDidMount(): void;
    componentDidUpdate(prevProps: GraphViewportProps, prevState: GraphViewportState): void;
    componentWillUnmount(): void;
    _renderSvgAsync(typeGraph: TypeGraph | null, displayOptions: VoyagerDisplayOptions | null): void;
    render(): JSX.Element;
    resize(): void;
    focusNode(id: string): void;
    _cleanupSvgViewport(): void;
}
export {};
