import './Voyager.css';
import './viewport.css';
import { ExecutionResult } from 'graphql/execution';
import { GraphQLSchema } from 'graphql/type';
import { IntrospectionQuery } from 'graphql/utilities';
import { type ReactNode } from 'react';
import { MaybePromise } from '../utils/usePromise';
export interface VoyagerDisplayOptions {
    rootType?: string;
    skipRelay?: boolean;
    skipDeprecated?: boolean;
    showLeafFields?: boolean;
    sortByAlphabet?: boolean;
    hideRoot?: boolean;
}
export interface VoyagerProps {
    introspection?: MaybePromise<ExecutionResult<IntrospectionQuery> | GraphQLSchema>;
    displayOptions?: VoyagerDisplayOptions;
    introspectionPresets?: {
        [name: string]: any;
    };
    allowToChangeSchema?: boolean;
    hideDocs?: boolean;
    hideSettings?: boolean;
    hideVoyagerLogo?: boolean;
    children?: ReactNode;
}
declare function Voyager(props: VoyagerProps): JSX.Element;
declare namespace Voyager {
    var PanelHeader: (props: {
        children: ReactNode;
    }) => JSX.Element;
}
export default Voyager;
