import './DocExplorer.css';
import { GraphQLNamedType } from 'graphql/type';
import { Component } from 'react';
import { TypeGraph } from '../../graph';
interface DocExplorerProps {
    typeGraph: TypeGraph | null;
    selectedTypeID: string | null;
    selectedEdgeID: string | null;
    onFocusNode: (id: string) => void;
    onSelectNode: (id: string | null) => void;
    onSelectEdge: (id: string | null) => void;
}
interface NavStackItem {
    title: string;
    type: GraphQLNamedType | null;
    searchValue: string | null;
}
interface DocExplorerState {
    navStack: ReadonlyArray<NavStackItem>;
    typeForInfoPopover: GraphQLNamedType | null;
}
export default class DocExplorer extends Component<DocExplorerProps, DocExplorerState> {
    state: DocExplorerState;
    static getDerivedStateFromProps(props: DocExplorerProps, state: DocExplorerState): DocExplorerState | null;
    render(): JSX.Element;
    handleSearch: (value: string) => void;
}
export {};
