interface Point {
    x: number;
    y: number;
}
interface Instance {
    resize(): Instance;
    zoom(scale: number): void;
    getPan(): Point;
    getZoom(): number;
    pan(point: Point): Instance;
    destroy(): void;
}
export declare class Viewport {
    container: HTMLElement;
    onSelectNode: (id: string | null) => void;
    onSelectEdge: (id: string) => void;
    $svg: SVGSVGElement;
    zoomer: Instance;
    offsetLeft: number;
    offsetTop: number;
    maxZoom: number;
    resizeObserver: ResizeObserver;
    constructor(svgString: string, container: HTMLElement, onSelectNode: (id: string | null) => void, onSelectEdge: (id: string) => void);
    resize(): void;
    enableZoom(): void;
    bindClick(): void;
    bindHover(): void;
    selectNodeById(id: string | null): void;
    selectNode(node: SVGElement): void;
    selectEdgeById(id: string | null): void;
    removeClass(selector: string, className: string): void;
    focusElement(id: string): void;
    animatePanAndZoom(x: number, y: number, zoomEnd: number): void;
    destroy(): void;
}
export {};
