import { GraphQLDirective, GraphQLNamedType, GraphQLSchema } from 'graphql';
declare module 'graphql' {
    interface GraphQLFieldExtensions<_TSource, _TContext, _TArgs> {
        isRelayField?: boolean;
    }
    interface GraphQLObjectTypeExtensions<_TSource, _TContext> {
        isRelayType?: boolean;
    }
    interface GraphQLInterfaceTypeExtensions {
        isRelayType?: boolean;
    }
}
export declare function getSchema(introspectionSchema: GraphQLSchema, sortByAlphabet: boolean, skipRelay: boolean, skipDeprecated: boolean): GraphQLSchema;
export declare function transformSchema(schema: GraphQLSchema, transformType: ReadonlyArray<(type: GraphQLNamedType) => GraphQLNamedType | null>, transformDirective?: ReadonlyArray<(directive: GraphQLDirective) => GraphQLDirective>): GraphQLSchema;
