'use strict';

exports.__esModule = true;
exports.default = {
  'Accessibility': ['body', 'disabled', 'disability', 'human', 'person'],
  'Achievement': ['award', 'medal', 'prize', 'trophy', 'winner'],
  'Action': ['connect', 'plug'],
  'Actions': ['gear', 'sun'],
  'Ad': ['advertising', 'marketing', 'promotion'],
  'Add': ['create', 'core', 'increase', 'increment', 'new', 'plus'],
  'AddCircle': ['create', 'increase', 'increment', 'new', 'plus'],
  'Aed': ['cpr', 'defibrillator', 'emergency', 'heart', 'medical', 'shock'],
  'Aggregate': ['add', 'combinatin', 'combine', 'join', 'merge'],
  'Aid': ['briefcase', 'care', 'emergency', 'first-aid', 'first aid kit', 'health', 'hospital'],
  'AidOption': ['briefcase', 'care', 'emergency', 'first-aid', 'first aid kit', 'health', 'hospital'],
  'Alarm': ['alert', 'alarmclock', 'bell', 'clock', 'hands', 'time', 'timer'],
  'Alert': ['alarm', 'attention', 'error', 'exclamation', 'important', 'warning'],
  'Amazon': ['buy', 'marketplace', 'online', 'shopping', 'social'],
  'Amex': ['atm', 'card', 'credit', 'pay', 'wallet', 'social'],
  'Analytics': ['chart', 'diagram', 'dontusepies', 'graph', 'pie', 'report', 'statistics'],
  'Android': ['cyborg', 'droid', 'humanoid', 'mobile', 'os', 'phone', 'robot', 'smartphone'],
  'Announce': ['bullhorn', 'loud', 'speaker', 'megaphone'],
  'Apple': ['donglebook', 'iphone', 'imac', 'logo', 'mac', 'macbook'],
  'Apps': ['grid', 'menu'],
  'Archive': ['backup', 'box', 'container', 'document', 'files', 'folder', 'storage'],
  'Archlinux': ['linux', 'logo', 'os'],
  'Article': ['blog', 'news', 'newspaper', 'press'],
  'Aruba': ['hpe', 'logo', 'networks', 'iot'],
  'Ascend': ['arrange', 'arrows', 'sort', 'up'],
  'AssistListening': ['accessibility', 'audio', 'ear', 'hear', 'sound'],
  'Atm': ['bank', 'card', 'credit', 'cash', 'finance', 'money'],
  'Attachment': ['clip', 'files', 'paper', 'paperclip'],
  'Attraction': ['amusement', 'carnival', 'circus', 'festival', 'tent'],
  'Baby': ['child', 'diaper', 'kid', 'newborn', 'person'],
  'BackTen': ['arrows', 'backward', 'rewind', 'player', 'seconds', 'skip'],
  'Bar': ['beer', 'cocktail', 'drink', 'glass', 'party'],
  'BarChart': ['analytics', 'business', 'chart', 'graph', 'diagram'],
  'Basket': ['buy', 'carton', 'checkout', 'picnic', 'shopping'],
  'Bike': ['bicycle', 'cycle', 'sport', 'transportation'],
  'Bitcoin': ['coin', 'currency', 'finance', 'social', 'pay', 'money', 'wallet'],
  'BlockQuote': ['formatting', 'text', 'editor'],
  'Blog': ['article', 'news', 'feed', 'web'],
  'Bold': ['formatting', 'text', 'editor'],
  'Book': ['education', 'learning', 'reading', 'study'],
  'Bookmark': ['document'],
  'BottomCorner': ['arrows', 'right'],
  'Braille': ['accessibility', 'blind'],
  'Briefcase': ['luggage', 'travel'],
  'Brush': ['tools', 'paint'],
  'Bug': ['fixing', 'insect', 'repair', 'virus'],
  'Bundle': ['money', 'stack'],
  'Bus': ['directions', 'transportation', 'travel', 'vehicle'],
  'BusinessService': ['briefcase', 'services'],
  'Cafeteria': ['cafe', 'dining', 'food', 'fork', 'meal', 'restaurant', 'silverware', 'spoon'],
  'Calculator': ['adding machine', 'accounting', 'math'],
  'Calendar': ['iappointment', 'date', 'day', 'event', 'plan', 'schedule', 'month'],
  'Camera': ['image', 'lens', 'photos', 'photograpy', 'picture', 'shot'],
  'Capacity': ['bars'],
  'Car': ['auto', 'directions', 'transportation', 'vehicle'],
  'CaretDown': ['arrows', 'core', 'direction', 'down', 'expand'],
  'CaretNext': ['arrows', 'core', 'direction', 'forward', 'right'],
  'CaretPrevious': ['arrows', 'core', 'direction', 'rewind', 'left'],
  'CaretUp': ['arrows', 'collapse', 'core', 'direction', 'up'],
  'Cart': ['buy', 'checkout', 'ecommerce', 'shopping'],
  'Catalog': ['catalogue', 'book', 'directory', 'document', 'index'],
  'CatalogOption': ['catalogue', 'book', 'directory', 'document', 'index'],
  'Centos': ['linux', 'logo', 'os'],
  'Channel': ['communications', 'media', 'network', 'tv', 'television'],
  'ChapterAdd': ['add', 'create', 'new', 'plus'],
  'ChapterNext': ['arrows', 'forward'],
  'ChapterPrevious': ['arrows', 'backward'],
  'Chat': ['bubble', 'conversation', 'communication', 'core', 'help', 'messages', 'talk', 'support'],
  'ChatOption': ['bubble', 'conversation', 'communication', 'core', 'help', 'messages', 'talk', 'support'],
  'Checkbox': ['mark', 'tick'],
  'CheckboxSelected': ['mark', 'tick'],
  'Checkmark': ['accept', 'agree', 'core', 'done', 'good', 'ok'],
  'Chrome': ['browser', 'google', 'logo', 'web'],
  'CircleInformation': ['document', 'faq', 'help', 'hint'],
  'CirclePlay': ['music', 'video'],
  'CircleQuestion': ['faq', 'help', 'support'],
  'Clear': ['forbidden', 'no', 'prohibited', 'stop'],
  'ClearOption': ['paintbrush'],
  'Cli': ['dos', 'line', 'command', 'console'],
  'Clipboard': ['document', 'list', 'report'],
  'Clock': ['date', 'timer', 'hands', 'hour', 'watch'],
  'Clone': ['copy', 'duplicate', 'layers'],
  'Close': ['cancel', 'core', 'delete', 'escape', 'exit', 'remove', 'trash'],
  'ClosedCaption': ['accessibility'],
  'Cloud': ['computing', 'data', 'network', 'storage', 'weather'],
  'CloudComputer': ['computing', 'data', 'network', 'storage'],
  'CloudDownload': ['arrows', 'computing', 'data', 'network', 'storage'],
  'CloudSoftware': ['application', 'computing', 'data', 'network', 'storage'],
  'CloudUpload': ['arrows', 'backup', 'computing', 'data', 'hosting', 'network', 'save', 'storage'],
  'Cloudlinux': ['hosting', 'logo', 'os'],
  'Cluster': ['interconnect', 'map', 'network'],
  'CoatCheck': ['clothes', 'hanger', 'hotel'],
  'Code': ['application', 'coding', 'development', 'programming', 'web'],
  'Codepen': ['codepen.io', 'code', 'demo', 'logo', 'media', 'share', 'social'],
  'Columns': ['chart', 'graph', 'layout', 'table'],
  'Compare': ['ab', 'a/b', 'analytics', 'balance', 'testing', 'variations'],
  'Compass': ['direction', 'location', 'map', 'navigation', 'tools'],
  'Compliance': ['checklist', 'clipboard', 'mark', 'protection'],
  'Configure': ['core', 'preferences', 'setting', 'settings', 'tools', 'wrench'],
  'Connect': ['network', 'plug'],
  'Connectivity': ['network', 'plug'],
  'Contact': ['bubble', 'ellipses'],
  'ContactInfo': ['avatar', 'icommunication', 'phone', 'profile'],
  'Contract': ['arrows', 'exit fullscreen', 'minimize'],
  'Copy': ['documents', 'duplicate', 'files', 'paste'],
  'CreativeCommons': ['creative commons', 'license', 'social'],
  'CreditCard': ['amex', 'atm', 'debit', 'mastercard', 'visa', 'wallet'],
  'Css3': ['code', 'coding', 'logo', 'stylesheet'],
  'Cube': ['3d', 'box', 'container', 'database', 'package'],
  'Cubes': ['3d', 'box', 'container', 'database', 'package'],
  'Currency': ['cash', 'dollar', 'finance', 'payment', 'money'],
  'Cursor': ['arrows', 'click', 'mouse', 'pointer'],
  'Cut': ['scissors', 'tools'],
  'Cycle': ['arrows', 'recycle', 'refresh', 'repeat'],
  'Dashboard': ['guage', 'speedometer'],
  'Database': ['rack', 'server', 'storage'],
  'Debian': ['logo', 'os'],
  'Deliver': ['delivery', 'shipping', 'transportation', 'truck'],
  'Deploy': ['rocket', 'spaceship'],
  'Descend': ['arrows', 'downward', 'sort'],
  'Desktop': ['computer', 'display', 'monitor', 'pc', 'screen'],
  'Detach': ['cut', 'paperclip', 'remove'],
  'Device': ['iot', 'technology', 'tv'],
  'Diamond': ['gem', 'jewelry', 'stone'],
  'Directions': ['arrows', 'location', 'navigation'],
  'Dislike': ['thumbs', 'down', 'like'],
  'Docker': ['app', 'container', 'logo', 'media', 'social'],
  'Document': ['core', 'files', 'format', 'folder', 'page', 'paper'],
  'DocumentCloud': ['cloud', 'files', 'folder', 'page', 'paper'],
  'DocumentConfig': ['files', 'folder', 'gear', 'page', 'paper'],
  'DocumentCsv': ['extension', 'files', 'format', 'folder', 'page', 'paper'],
  'DocumentDownload': ['arrows', 'files', 'import', 'get', 'page', 'paper', 'receive'],
  'DocumentExcel': ['extension', 'files', 'format', 'folder', 'microsoft', 'office', 'page', 'paper', 'xls'],
  'DocumentImage': ['files', 'folder', 'page', 'paper', 'photography', 'photos', 'picture'],
  'DocumentLocked': ['files', 'folder', 'page', 'paper', 'password', 'secure', 'security'],
  'DocumentMissing': ['delete', 'error', 'files', 'folder', 'page', 'paper', 'remove'],
  'DocumentNotes': ['extension', 'files', 'folder', 'page', 'paper'],
  'DocumentOutlook': ['extension', 'files', 'folder', 'microsoft', 'office', 'page', 'paper'],
  'DocumentPdf': ['extension', 'files', 'folder', 'format', 'page', 'paper'],
  'DocumentPerformance': ['arrows', 'files', 'folder', 'format', 'page', 'paper'],
  'DocumentPpt': ['extension', 'files', 'folder', 'microsoft', 'office', 'page', 'paper', 'powerpoint'],
  'DocumentRtf': ['extension', 'files', 'folder', 'format', 'page', 'paper'],
  'DocumentSound': ['audio', 'files', 'folder', 'music', 'page', 'paper'],
  'DocumentStore': ['data', 'files', 'folder', 'page', 'paper'],
  'DocumentTest': ['biology', 'chemistry', 'files', 'flask', 'folder', 'page', 'paper', 'research', 'science'],
  'DocumentText': ['extension', 'files', 'folder', 'format', 'page', 'paper'],
  'DocumentThreat': ['bomb', 'danger', 'files', 'folder', 'malware', 'page', 'paper', 'virus'],
  'DocumentTime': ['alarm', 'clock', 'event', 'files', 'folder', 'hands', 'page', 'paper'],
  'DocumentTransfer': ['arrows', 'files', 'folder', 'page', 'paper'],
  'DocumentTxt': ['extension', 'files', 'folder', 'format', 'page', 'paper'],
  'DocumentUpdate': ['arrows', 'files', 'folder', 'page', 'paper', 'refresh'],
  'DocumentUpload': ['arrows', 'files', 'import', 'get', 'page', 'paper', 'send'],
  'DocumentUser': ['account', 'avatar', 'files', 'folder', 'page', 'paper', 'person', 'profile'],
  'DocumentVerified': ['check', 'files', 'folder', 'mark', 'page', 'paper'],
  'DocumentVideo': ['camera', 'files', 'folder', 'page', 'paper', 'video'],
  'DocumentWindows': ['executable', 'extension', 'files', 'folder', 'page', 'paper'],
  'DocumentWord': ['extension', 'files', 'folder', 'microsoft', 'office', 'page', 'paper'],
  'DocumentZip': ['compressed', 'extension', 'files', 'folder', 'format', 'page', 'paper'],
  'Domain': ['internet', 'website', 'www'],
  'Dos': ['command', 'code', 'files', 'os'],
  'Down': ['arrows', 'expand', 'direction', 'drop'],
  'Download': ['arrows', 'cloud', 'core', 'import', 'get', 'receive'],
  'Drag': ['drop'],
  'DriveCage': ['data', 'disk', 'rack', 'storage'],
  'Dropbox': ['box', 'cloud', 'logo', 'media', 'share', 'social'],
  'Duplicate': ['add', 'copy'],
  'Dxc': ['awesome', 'logo'],
  'Edge': ['browser', 'logo', 'microsoft', 'web'],
  'Edit': ['change', 'core', 'draw', 'modify', 'pen', 'pencil', 'write'],
  'Eject': ['media', 'player'],
  'Elevator': ['down', 'lift', 'up', 'transportation'],
  'Emergency': ['alert', 'asterisk'],
  'Emoji': ['emoticon', 'reaction', 'comment'],
  'EmptyCircle': ['chart', 'donut'],
  'Erase': ['delete', 'eraser', 'remove'],
  'Escalator': ['stairs', 'staircase', 'moving', 'transportation', 'person', 'up'],
  'Expand': ['arrows', 'direction', 'maximize', 'full', 'screen'],
  'Facebook': ['share', 'logo', 'media', 'network', 'social'],
  'FacebookOption': ['share', 'logo', 'media', 'network', 'social'],
  'Fan': ['air', 'cooling', 'ventilator'],
  'FastForward': ['arrows', 'next', 'player', 'right'],
  'Favorite': ['heart', 'like'],
  'Fedora': ['logo', 'os'],
  'Filter': ['core', 'funnel', 'refine', 'sort', 'triage'],
  'FingerPrint': ['security', 'biometric', 'scan'],
  'Fireball': ['star'],
  'Firefox': ['browser', 'logo', 'web'],
  'Flag': ['core', 'nation', 'warn', 'warning'],
  'Folder': ['documents', 'data', 'files'],
  'FolderCycle': ['documents', 'data', 'files', 'recycle', 'refresh'],
  'FolderOpen': ['documents', 'data', 'files'],
  'FormAdd': ['create', 'form', 'increase', 'increment', 'new', 'plus'],
  'formAttachment': ['attach', 'clip', 'files', 'form', 'paper', 'upload'],
  'FormCalendar': ['date', 'day', 'event', 'form', 'month', 'schedule', 'year'],
  'FormCheckmark': ['accept', 'agree', 'done', 'form', 'good', 'ok'],
  'FormClock': ['alarm', 'form', 'hour', 'minute', 'second', 'time', 'timer', 'watch'],
  'FormClose': ['cancel', 'close', 'delete', 'escape', 'exit', 'form', 'remove', 'trash'],
  'FormCut': ['scissors', 'form', 'tools'],
  'FormDown': ['arrows', 'direction', 'form', 'down', 'expand', 'up'],
  'FormFilter': ['form', 'funnel', 'refine', 'sort', 'triage'],
  'FormFolder': ['files', 'document', 'form', 'organize'],
  'FormLocation': ['directions', 'form', 'gps', 'map', 'navigation', 'pin'],
  'FormLock': ['close', 'form', 'locker', 'password', 'permissions', 'protection', 'secure', 'security'],
  'FormNext': ['arrows', 'direction', 'form', 'forward', 'next', 'right'],
  'FormNextLink': ['arrows', 'direction', 'form', 'forward', 'next', 'right'],
  'FormPrevious': ['arrows', 'back', 'backward', 'direction', 'form', 'left', 'return'],
  'FormPreviousLink': ['arrows', 'back', 'backward', 'direction', 'form', 'left', 'return'],
  'FormRefresh': ['arrows', 'form', 'pull', 'reload', 'sync', 'update'],
  'FormSchedule': ['appointment', 'calendar', 'date', 'event', 'form', 'meeting', 'time'],
  'FormSearch': ['find', 'form', 'lookup', 'magnifier', 'search'],
  'FormSubtract': ['decrement', 'delete', 'form', 'minus', 'reduce', 'remove'],
  'FormTrash': ['bin', 'clear', 'core', 'delete', 'eliminate', 'form', 'garbage', 'remove'],
  'FormUp': ['arrows', 'direction', 'collapse', 'form', 'up'],
  'FormUpload': ['arrows', 'attach', 'attachment', 'cloud', 'export', 'files', 'form', 'send'],
  'FormView': ['eye', 'form', 'open'],
  'FormViewHide': ['close', 'eye', 'form'],
  'ForwardTen': ['arrows', 'seconds', 'player', 'skip'],
  'Freebsd': ['logo', 'os', 'unix'],
  'Gallery': ['image', 'pictures', 'photography', 'photos'],
  'Gamepad': ['joystick', 'play', 'sports'],
  'Gift': ['birthday', 'box', 'christmas', 'present'],
  'Github': ['code', 'demo', 'logo', 'media', 'share', 'social', 'opensource'],
  'Globe': ['earth', 'global', 'internet', 'planet', 'world'],
  'Golang': ['code', 'google', 'logo'],
  'Google': ['logo', 'search'],
  'GooglePlus': ['logo', 'media', 'share', 'social'],
  'GoogleWallet': ['logo', 'media', 'online', 'pay', 'social', 'transaction', 'wallet'],
  'Gremlin': ['awesome', 'grommet'],
  'Grid': ['line', 'layout'],
  'Grommet': ['awesome', 'logo'],
  'Group': ['people', 'team', 'person', 'users'],
  'Grow': ['growth', 'plant'],
  'Hadoop': ['big', 'database', 'logo'],
  'Halt': ['hand', 'sign', 'stop'],
  'Help': ['hint', 'information', 'service', 'support', 'question'],
  'Heroku': ['cloud', 'deployment', 'logo', 'paas'],
  'History': ['backup', 'clock', 'hands', 'timer', 'schedule'],
  'Home': ['building', 'estate', 'house', 'real'],
  'Horton': ['big', 'data', 'logo'],
  'Host': ['computer', 'database', 'hosting', 'mainframe', 'rack', 'server'],
  'HostMaintenance': ['hosting', 'rack', 'server', 'service', 'settings', 'repair'],
  'Hp': ['awesome', 'hewlett', 'logo', 'packard'],
  'Hpe': ['awesome', 'enterprise', 'hewlett', 'iot', 'logo', 'packard'],
  'HpeLabs': ['awesome', 'enterprise', 'hewlett', 'logo', 'packard'],
  'Hpi': ['awesome', 'hewlett', 'logo', 'packard'],
  'Html5': ['code', 'coding', 'web'],
  'IceCream': ['dessert', 'food'],
  'Image': ['photography', 'photos', 'picture'],
  'Impact': ['crash', 'explode'],
  'InProgress': ['clock', 'hourglass', 'timer'],
  'Inbox': ['email', 'messages', 'letter', 'tray'],
  'Indicator': ['location', 'marker', 'pin'],
  'Info': ['bulb', 'data', 'help', 'idea', 'information', 'light', 'support'],
  'Inherit': ['family', 'pedigree', 'tree'],
  'Inspect': ['eye', 'glasses', 'spectacles'],
  'Instagram': ['camera', 'image', 'logo', 'media', 'picture', 'photography', 'photos', 'share', 'social', 'video'],
  'Install': ['configuration', 'download', 'settings', 'setup'],
  'InstallOption': ['arrows', 'configuration', 'download', 'settings', 'setup'],
  'Integration': ['connection', 'plug', 'system'],
  'InternetExplorer': ['browser', 'logo', 'web'],
  'Italic': ['formatting', 'text', 'editor'],
  'Iteration': ['cascade', 'iterate', 'repeat', 'stack', 'steps'],
  'Java': ['coffee', 'code', 'coding', 'cup'],
  'Language': ['earth', 'internet', 'translate', 'world'],
  'Launch': ['rocket', 'spaceship', 'startup'],
  'Layer': ['arrange', 'cascade', 'layers', 'stack'],
  'License': ['key', 'lock'],
  'Like': ['favorite', 'heart', 'thumbs', 'up'],
  'LineChart': ['graph', 'grow', 'time'],
  'Link': ['chain', 'connection', 'network', 'web'],
  'LinkBottom': ['align', 'arrows', 'direction', 'down'],
  'LinkDown': ['arrows', 'direction', 'down'],
  'LinkNext': ['arrows', 'core', 'direction', 'forward', 'next', 'right'],
  'LinkPrevious': ['arrows', 'back', 'backward', 'core', 'direction', 'left', 'return'],
  'LinkTop': ['arrows', 'direction', 'up'],
  'LinkUp': ['arrows', 'direction', 'up'],
  'Linkedin': ['logo', 'network', 'media', 'share', 'social'],
  'LinkedinOption': ['logo', 'network', 'media', 'share', 'social'],
  'Local': ['flag', 'language', 'location', 'usa'],
  'Location': ['gps', 'map', 'navigation', 'pin'],
  'LocationPin': ['gps', 'map', 'navigation', 'pin'],
  'Lock': ['close', 'key', 'password', 'protectio', 'secure', 'security'],
  'Login': ['account', 'arrows', 'door', 'password', 'security'],
  'Logout': ['account', 'arrows', 'door', 'exit', 'password', 'security'],
  'Lounge': ['chair', 'furniture', 'sofa'],
  'Magic': ['wand', 'wizard'],
  'Mail': ['email', 'envelope', 'letter', 'messages', 'social'],
  'MailOption': ['email', 'envelope', 'letter', 'messages', 'social'],
  'Mandriva': ['linux', 'logo', 'os'],
  'Manual': ['stick', 'joystick'],
  'Map': ['gps', 'location', 'navigation', 'pin'],
  'MapLocation': ['gps', 'location', 'navigation', 'pin'],
  'Mastercard': ['card', 'credit', 'logo', 'pay', 'wallet', 'social', 'visa'],
  'Medium': ['blog', 'logo', 'media', 'share', 'social'],
  'Menu': ['hamburger', 'list', 'navigation', 'options'],
  'Microfocus': ['awesome', 'logo'],
  'Microphone': ['audio', 'mic', 'music', 'sound'],
  'Money': ['cash', 'coins', 'currency', 'dollar', 'finance'],
  'Monitor': ['computer', 'crt', 'desktop', 'display', 'screen'],
  'Monospace': ['formatting', 'text', 'editor'],
  'More': ['actions', 'core', 'ellipses'],
  'Multimedia': ['clapboard', 'cinema', 'film', 'video', 'movie'],
  'Multiple': ['cascade', 'repeat', 'stack', 'steps'],
  'Music': ['audio', 'notes', 'sound', 'play'],
  'Mysql': ['database', 'logo', 'storage'],
  'Navigate': ['guide', 'road', 'sign', 'street', 'way'],
  'New': ['asterisk', 'add', 'create', 'plus'],
  'NewWindow': ['add', 'create', 'plus'],
  'Next': ['arrows', 'core', 'direction', 'forward', 'next', 'right'],
  'Nodes': ['connection', 'network'],
  'Norton': ['logo', 'security'],
  'Note': ['document', 'file', 'paper'],
  'Notes': ['document', 'file', 'paper'],
  'Notification': ['alarm', 'alert', 'bell', 'core', 'messages', 'notify', 'warn', 'warning'],
  'ObjectGroup': [''],
  'ObjectUngroup': [''],
  'OfflineStorage': ['backup', 'tape'],
  'Onedrive': ['logo', 'office'],
  'Opera': ['browser', 'logo', 'web'],
  'Optimize': ['analytics', 'chart', 'growth'],
  'Oracle': ['cloud', 'database', 'logo'],
  'OrderedList': ['formatting', 'text', 'items', 'editor'],
  'Organization': ['building'],
  'Overview': ['binoculars'],
  'Paint': ['bucket', 'color'],
  'Pan': ['arrows', 'drag', 'move'],
  'Pause': ['player'],
  'PauseFill': ['player'],
  'Paypal': ['card', 'logo', 'media', 'money', 'social', 'pay', 'wallet'],
  'Performance': ['optimization'],
  'PersonalComputer': ['pc', 'monitor', 'screen'],
  'PieChart': ['analytics', 'dontusepies', 'graph'],
  'PiedPiper': ['logo', 'storage'],
  'Pin': ['gps', 'location', 'map', 'navigation', 'pin', 'tack'],
  'Pinterest': ['logo', 'media', 'share', 'social'],
  'Plan': ['calendar', 'checklist', 'schedule'],
  'Play': ['media', 'music', 'player', 'video'],
  'PlayFill': ['media', 'music', 'player', 'video'],
  'Power': ['off', 'switch'],
  'Previous': ['arrows', 'back', 'backward', 'core', 'direction', 'left', 'return'],
  'Print': ['laser', 'printer'],
  'ProductHunt': ['logo', 'media', 'share', 'social'],
  'Radial': ['circle', 'radio', 'off'],
  'RadialSelected': ['circle', 'radio', 'on'],
  'Raspberry': ['logo', 'pc', 'pie', 'iot'],
  'Reactjs': ['javascript', 'logo'],
  'Reddit': ['logo', 'media', 'online', 'social', 'share'],
  'Redhat': ['linux', 'logo', 'Fedora', 'os'],
  'Redo': ['action', 'text', 'editor'],
  'Refresh': ['arrows', 'backup', 'core', 'reload', 'repeat', 'pull', 'sync', 'update'],
  'Resources': ['cascade', 'layers', 'multiple', 'stack'],
  'Restaurant': ['chef', 'cook', 'food', 'hat'],
  'Restroom': ['bathroom', 'toilet', 'water', 'closet'],
  'RestroomMen': ['bathroom', 'closet', 'man', 'person', 'toilet', 'water', 'wc'],
  'RestroomWomen': ['bathroom', 'closet', 'person', 'toilet', 'water', 'wc', 'woman'],
  'Resume': ['forward', 'media', 'player'],
  'Revert': ['arrows', 'history', 'undo'],
  'Rewind': ['back', 'media', 'player'],
  'Risk': ['casino', 'dice', 'game', 'gaming', 'probability'],
  'Robot': ['android', 'automatic', 'automation', 'career', 'job', 'layoff', 'machine'],
  'RotateLeft': ['direction', 'rotate', 'picture'],
  'RotateRight': ['direction', 'rotate', 'picture'],
  'Rss': ['feed', 'news', 'signal', 'syndication'],
  'Run': ['exit', 'evacuation', 'fire', 'lead', 'person', 'sport'],
  'SafariOption': ['browser', 'logo', 'web'],
  'Satellite': ['antenna', 'communication', 'dish', 'space'],
  'Save': ['arrows', 'floppy', 'store', 'storage'],
  'Scan': ['document', 'scanner'],
  'Schedule': ['agenda', 'appointment', 'calendar', 'checklist', 'month', 'plan'],
  'ScheduleNew': ['add', 'agenda', 'asterisk', 'appointment', 'calendar', 'checklist', 'month', 'plan'],
  'SchedulePlay': ['agenda', 'appointment', 'calendar', 'checklist', 'month', 'plan'],
  'Schedules': ['agenda', 'appointment', 'calendar', 'checklist', 'month', 'plan'],
  'Sco': ['logo', 'os', 'unix'],
  'Scorecard': ['clipboard', 'game', 'mark'],
  'Search': ['core', 'find', 'lookup', 'magnifier', 'zoom'],
  'SearchAdvanced': ['find', 'lookup', 'magnifier', 'plus', 'zoom'],
  'Secure': ['closed', 'locked', 'security'],
  'Select': ['cursor', 'pointer', 'selection'],
  'Selection': ['column'],
  'Semantics': ['chevron', 'html', 'w3c'],
  'Send': ['airplane', 'email', 'messages', 'paper'],
  'Server': ['computer', 'hosting', 'mainframe', 'servers'],
  'ServerCluster': ['cluster', 'computer', 'hosting', 'mainframe', 'servers'],
  'Servers': ['cluster', 'computer', 'hosting', 'mainframe', 'servers'],
  'ServicePlay': ['cloud', 'services'],
  'Services': ['action', 'cloud', 'gears'],
  'SettingsOption': ['configure', 'gear'],
  'Share': ['connections', 'export', 'sharing', 'open', 'network', 'publish'],
  'ShareOption': ['connections', 'sharing', 'score', 'social', 'media', 'open', 'network', 'publish'],
  'Shield': ['antivirus', 'secure', 'security'],
  'ShieldSecurity': ['gear', 'secure', 'security', 'settings'],
  'Shift': ['divide', 'partition', 'separate', 'split'],
  'Shop': ['buy', 'cart', 'checkout', 'bag', 'shopping'],
  'Sidebar': ['columns', 'layout', 'navigation', 'right'],
  'Sign': ['devil', 'hand', 'heavy', 'horns', 'metal', 'rock'],
  'Skype': ['call', 'chat', 'conference', 'logo', 'media', 'phone', 'social', 'video'],
  'Slack': ['chat', 'help', 'logo', 'media', 'messages', 'talk', 'share', 'social', 'support'],
  'Snapchat': ['ghost', 'image', 'logo', 'media', 'picture', 'photography', 'photos', 'share', 'social', 'video'],
  'Solaris': ['logo', 'oracle', 'os', 'sun', 'unix'],
  'Sort': ['bullets', 'list', 'items'],
  'Spa': ['lotus', 'plant', 'flower', 'yoga'],
  'Split': ['columns', 'layout', 'navigation'],
  'Splits': ['columns', 'layout', 'navigation'],
  'Square': ['logo', 'media', 'social', 'pay', 'wallet'],
  'StackOverflow': ['code', 'help', 'logo', 'media', 'share', 'social'],
  'Stakeholder': ['business', 'person'],
  'Star': ['badge', 'rating'],
  'StarHalf': ['badge', 'rating'],
  'StatusCritical': ['error', 'halt', 'stop', 'warning'],
  'StatusCriticalSmall': ['error', 'halt', 'stop', 'warning'],
  'StatusDisabled': ['off'],
  'StatusDisabledSmall': ['off'],
  'StatusGood': ['accept', 'check', 'ok'],
  'StatusGoodSmall': ['accept', 'check', 'ok'],
  'StatusInfo': ['faq', 'help', 'hint', 'information'],
  'StatusInfoSmall': ['faq', 'help', 'hint', 'information'],
  'StatusPlaceholder': ['box'],
  'StatusUnknown': ['question'],
  'StatusUnknownSmall': ['question'],
  'StatusWarning': ['exclamation'],
  'StatusWarningSmall': ['exclamation'],
  'Steps': ['staircase', 'stairs'],
  'StepsOption': ['staircase', 'stairs', 'stairway'],
  'Stop': ['halt', 'player'],
  'StopFill': ['halt', 'player'],
  'Storage': ['archives', 'drawers'],
  'StreetView': ['location', 'map', 'person'],
  'StrikeThrough': ['formatting', 'text', 'editor'],
  'Stripe': ['logo', 'media', 'pay', 'social', 'wallet'],
  'Subscript': ['formatting', 'text', 'editor'],
  'Subtract': ['core', 'decrement', 'minus', 'reduce', 'remove', 'subtraction'],
  'SubtractCircle': ['decrement', 'minus', 'reduce', 'remove', 'subtraction'],
  'Superscript': ['formatting', 'text', 'editor'],
  'Support': ['help', 'life', 'lifesaver', 'preserver', 'safety'],
  'Suse': ['logo', 'linux', 'os'],
  'Swift': ['code', 'logo'],
  'Swim': ['person', 'sport', 'swimmer', 'swimming'],
  'Sync': ['refresh', 'reload', 'update'],
  'System': ['computer', 'configuration', 'gear', 'settings'],
  'Table': ['spreadsheet'],
  'TableAdd': ['new', 'plus', 'spreadsheet'],
  'Tag': ['label', 'retail', 'ticket', 'travel'],
  'Tape': ['archive', 'backup', 'storage'],
  'TapeOption': ['archive', 'backup', 'storage'],
  'Target': ['bulleye', 'darts', 'goal'],
  'Task': ['details', 'done', 'list', 'survey'],
  'Tasks': ['bar', 'progress'],
  'Technology': ['circuit', 'device', 'electronics'],
  'Template': ['application', 'columns', 'layout', 'navigation'],
  'Terminal': ['admin', 'command', 'console', 'dos', 'prompt'],
  'Test': ['biology', 'chemistry', 'experiment', 'flask', 'healthcare', 'laboratory', 'research', 'science'],
  'TestDesktop': ['biology', 'chemistry', 'experiment', 'laboratory', 'prototype', 'research', 'science'],
  'TextAlignCenter': ['formatting', 'center', 'text', 'align', 'editor'],
  'TextAlignFull': ['formatting', 'full', 'text', 'align', 'editor'],
  'TextAlignLeft': ['formatting', 'left', 'text', 'align', 'editor'],
  'TextAlignRight': ['formatting', 'right', 'text', 'align', 'editor'],
  'TextWrap': ['around'],
  'Threats': ['bomb', 'danger', 'explosive', 'security'],
  'ThreeD': ['3d', 'cube', 'box', 'rotation'],
  'ThreeDffects': ['3d', 'cube', 'box'],
  'Ticket': ['cinema', 'concert', 'movie', 'travel'],
  'Tip': ['bubble', 'chat', 'messages', 'tooltip'],
  'Toast': ['alert', 'food', 'messages'],
  'Tools': ['hammer', 'mallet'],
  'Tooltip': ['bubble', 'chat', 'elipses', 'messages'],
  'TopCorner': ['arrows', 'left'],
  'Train': ['railroad', 'subway', 'transportation', 'travel'],
  'Transaction': ['activity', 'arrows'],
  'Trash': ['bin', 'clear', 'core', 'delete', 'eliminate', 'garbage', 'remove'],
  'Tree': ['branch', 'flow', 'organizstion', 'view'],
  'TreeOption': ['branch', 'forest', 'plant'],
  'Trigger': ['bolt', 'electricity', 'lightning', 'power', 'quick', 'storm'],
  'Trophy': ['award', 'cup', 'medal', 'prize', 'trophy', 'winner'],
  'Troubleshoot': ['screwdriver', 'tools', 'wrench'],
  'Tty': ['accessibility', 'teletype', 'teleprinter', 'tdd'],
  'Tumblr': ['blog', 'image', 'logo', 'medi,ia', 'picture', 'photography', 'photos', 'share', 'social', 'video'],
  'Turbolinux': ['linux', 'logo', 'os'],
  'Twitter': ['bird', 'logo', 'media', 'share', 'social', 'tweet'],
  'Ubuntu': ['linux', 'logo', 'os'],
  'Underline': ['formatting', 'text', 'editor'],
  'Undo': ['action', 'text', 'editor'],
  'Unlink': ['break', 'chain', 'disconnect'],
  'Unlock': ['open', 'key', 'password', 'protection', 'secure', 'security'],
  'UnorderedList': ['formatting', 'text', 'items', 'editor'],
  'Up': ['arrows', 'collapse', 'direction'],
  'Update': ['arrows', 'change', 'core', 'reload', 'refresh'],
  'Upgrade': ['arrows', 'circle'],
  'Upload': ['arrows', 'attach', 'attachment', 'cloud', 'core', 'export', 'files', 'send'],
  'User': ['account', 'avatar', 'core', 'person', 'profile', 'male', 'man'],
  'UserAdd': ['add', 'account', 'avatar', 'new', 'person', 'profile'],
  'UserAdmin': ['account', 'avatar', 'person', 'profile', 'security', 'key'],
  'UserExpert': ['account', 'admin', 'avatar', 'check', 'person', 'profile', 'security', 'key'],
  'UserFemale': ['account', 'avatar', 'core', 'person', 'profile', 'woman'],
  'UserManager': ['account', 'avatar', 'boss', 'person', 'profile'],
  'UserNew': ['add', 'account', 'avatar', 'new', 'person', 'profile'],
  'UserPolice': ['account', 'avatar', 'marshal', 'officer', 'person', 'profile', 'sheriff'],
  'UserSettings': ['account', 'avatar', 'gear', 'person', 'profile', 'settings'],
  'UserWorker': ['account', 'avatar', 'construction', 'hardhat', 'helmut', 'person', 'profile', 'safety'],
  'Validate': ['accept', 'approve', 'ok', 'success'],
  'Vend': ['automated', 'dispensing', 'snacks', 'vending'],
  'Video': ['camera', 'movie'],
  'View': ['eye', 'open', 'visibility'],
  'Vimeo': ['logo', 'media', 'share', 'social', 'video'],
  'VirtualMachine': ['vmware'],
  'Visa': ['amex', 'card', 'credit', 'mastercard', 'media', 'pay', 'social', 'wallet'],
  'VmMaintenance': ['tools', 'vmware', 'wrench'],
  'Vmware': ['logo', 'virtual'],
  'Volume': ['audio', 'sound', 'speaker'],
  'VolumeControl': ['audio', 'sound', 'speaker'],
  'VolumeLow': ['audio', 'sound', 'speaker'],
  'VolumeMute': ['audio', 'mute', 'sound', 'speaker'],
  'Vulnerability': ['aim', 'crosshairs', 'hunting', 'security', 'target'],
  'Waypoint': ['arrows', 'cursor', 'compass', 'gps', 'location', 'navigation'],
  'Wheelchair': ['accessibility', 'disabled', 'disability', 'handicap', 'person'],
  'WheelchairActive': ['accessibility', 'disabled', 'disability', 'handicap', 'person'],
  'Windows': ['pc', 'logo'],
  'WindowsLegacy': ['pc', 'logo'],
  'Wordpress': ['blog', 'logo', 'media', 'share', 'social'],
  'Workshop': ['business', 'conference', 'speaker'],
  'Yoga': ['asana', 'person', 'sport'],
  'Youtube': ['logo', 'media', 'play', 'share', 'social', 'video'],
  'ZoomIn': ['in', 'plus', 'magnify'],
  'ZoomOut': ['out', 'minus', 'magnify']
};